# cordova-plugin-qrscanner-tests

This is the Cordova Testing Framework project for `cordova-plugin-qrscanner`.

To generate this package, clone and `npm install` the `cordova-plugin-qrscanner`, and then run `npm run manual-tests` inside that project.

Becuase this project requires `cordova-plugin-qrscanner` and it's tests as plugins, building this project inside the `cordova-plugin-qrscanner` directory would cause an infinite recursion.

Since `cordova prepare` is not intended to handle this scenario (which may at some point be resolved/added by the Cordova CLI), this package is first copied into a sibling directory called `cordova-plugin-test-projects`. The path from the root of `cordova-plugin-qrscanner` is `../cordova-plugin-test-projects/cordova-plugin-qrscanner-tests/`.

## Running Tests

Run the app on each platform to test functionality. The "Auto Tests" run a sanity check on the plugin's globally exposed javascript interface. The "Manual Tests" allow for human confirmation that each function performs as expected.

### iOS

Run tests on connected device: `cordova run ios --device`

Run tests on ios simulator: `cordova emulate ios`

Open test project in xcode: `open platforms/ios/HelloCordova.xcodeproj/`

XCode will usually ask if you'd like to "Convert [the project] to [the] Latest Swift Syntax" – the plugin uses the latest syntax, but the project generated by `cordova build` doesn't seem to verify this for XCode. It's safe to ignore ("Cancel") the dialog.

## Android

Before testing with Android, please install [Java Development Kit (JDK) 8](http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html), [Android Studio](https://developer.android.com/studio/index.html), and the SDK packages for whatever [API level](https://developer.android.com/guide/topics/manifest/uses-sdk-element.html#ApiLevels) you wish to target.

Cordova's CLI tools require some environment variables to be set in order to function correctly. The CLI will attempt to set these variables for you, but in certain cases you may need to set them manually. Please refer to [Cordova's Android Platform Guide](https://cordova.apache.org/docs/en/latest/guide/platforms/android/index.html) for more information.

Please make sure you have Gradle updated. If you get an error stating `Gradle Version 2.10 is required`, ensure you select `Use default Gradle wrapper` when starting Android Studio. Then edit the `Project/gradle/wrapper/gradle-wrapper.properties` file and change the distributionUrl line to `distributionUrl=http\://services.gradle.org/distributions/gradle-2.10-all.zip`.

## Other Notes

We use a timestamp in the `config.xml`'s `<widget>` `id` field so the app has a different identifier for each build. This allows us to test user-granted permissions – as if the app has never been installed – every time we re-build.

The seemingly unecessary dependency on `lodash-node` prevents an occasional and elusive bug in the `cordova build` command.
