/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.api;

import android.app.NotificationManager;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import cn.jiguang.api.JCoreManager;
import cn.jpush.android.a;
import cn.jpush.android.api.PushNotificationBuilder;
import cn.jpush.android.api.TagAliasCallback;
import cn.jpush.android.b.d;
import cn.jpush.android.data.JPushLocalNotification;
import cn.jpush.android.h.c;
import cn.jpush.android.helper.JCoreHelper;
import cn.jpush.android.helper.Logger;
import cn.jpush.android.helper.f;
import cn.jpush.android.helper.g;
import cn.jpush.android.helper.h;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class JPushInterface {
    public static final String PUSH_MESSAGE_PERMISSION_POSTFIX = ".permission.JPUSH_MESSAGE";
    public static final String ACTION_CONNECTION_CHANGE = "cn.jpush.android.intent.CONNECTION";
    public static final String ACTION_REGISTRATION_ID = "cn.jpush.android.intent.REGISTRATION";
    public static final String ACTION_MESSAGE_RECEIVED = "cn.jpush.android.intent.MESSAGE_RECEIVED";
    public static final String ACTION_NOTIFICATION_RECEIVED = "cn.jpush.android.intent.NOTIFICATION_RECEIVED";
    public static final String ACTION_NOTIFICATION_OPENED = "cn.jpush.android.intent.NOTIFICATION_OPENED";
    public static final String ACTION_NOTIFICATION_CLICK_ACTION = "cn.jpush.android.intent.NOTIFICATION_CLICK_ACTION";
    public static final String ACTION_NOTIFICATION_CLICK_ACTION_PROXY = "cn.jpush.android.intent.NOTIFICATION_CLICK_ACTION_PROXY";
    public static final String ACTION_NOTIFICATION_RECEIVED_PROXY = "cn.jpush.android.intent.NOTIFICATION_RECEIVED_PROXY";
    public static final String EXTRA_CONNECTION_CHANGE = "cn.jpush.android.CONNECTION_CHANGE";
    public static final String EXTRA_REGISTRATION_ID = "cn.jpush.android.REGISTRATION_ID";
    public static final String EXTRA_APP_KEY = "cn.jpush.android.APPKEY";
    public static final String EXTRA_NOTIFICATION_DEVELOPER_ARG0 = "cn.jpush.android.NOTIFICATION_DEVELOPER_ARG0";
    public static final String EXTRA_NOTIFICATION_TITLE = "cn.jpush.android.NOTIFICATION_CONTENT_TITLE";
    public static final String EXTRA_NOTIFICATION_URL = "cn.jpush.android.NOTIFICATION_URL";
    public static final String EXTRA_PUSH_ID = "cn.jpush.android.PUSH_ID";
    public static final String EXTRA_MSG_ID = "cn.jpush.android.MSG_ID";
    public static final String EXTRA_NOTI_TYPE = "cn.jpush.android.NOTIFICATION_TYPE";
    public static final String EXTRA_ALERT = "cn.jpush.android.ALERT";
    public static final String EXTRA_ALERT_TYPE = "cn.jpush.android.ALERT_TYPE";
    public static final String EXTRA_MESSAGE = "cn.jpush.android.MESSAGE";
    public static final String EXTRA_CONTENT_TYPE = "cn.jpush.android.CONTENT_TYPE";
    public static final String EXTRA_TITLE = "cn.jpush.android.TITLE";
    public static final String EXTRA_BIG_TEXT = "cn.jpush.android.BIG_TEXT";
    public static final String EXTRA_INBOX = "cn.jpush.android.INBOX";
    public static final String EXTRA_BIG_PIC_PATH = "cn.jpush.android.BIG_PIC_PATH";
    public static final String EXTRA_EXTRA = "cn.jpush.android.EXTRA";
    public static final String EXTRA_NOTI_PRIORITY = "cn.jpush.android.NOTI_PRIORITY";
    public static final String EXTRA_NOTI_CATEGORY = "cn.jpush.android.NOTI_CATEGORY";
    public static final String EXTRA_NOTIFICATION_ID = "cn.jpush.android.NOTIFICATION_ID";
    public static final String EXTRA_NOTIFICATION_ACTION_EXTRA = "cn.jpush.android.NOTIFIACATION_ACTION_EXTRA";
    public static final String EXTRA_NOTIFICATION_SMALL_ICON = "cn.jpush.android.NOTIFICATION_SMALL_ICON";
    public static final String EXTRA_NOTIFICATION_LARGET_ICON = "cn.jpush.android.NOTIFICATION_LARGE_ICON";
    public static final String EXTRA_ACTIVITY_PARAM = "cn.jpush.android.ACTIVITY_PARAM";
    public static final String EXTRA_RICHPUSH_FILE_PATH = "cn.jpush.android.FILE_PATH";
    public static final String EXTRA_RICHPUSH_FILE_TYPE = "cn.jpush.android.FILE_TYPE";
    public static final String EXTRA_RICHPUSH_HTML_PATH = "cn.jpush.android.HTML_PATH";
    public static final String EXTRA_RICHPUSH_HTML_RES = "cn.jpush.android.HTML_RES";
    public static final String EXTRA_STATUS = "cn.jpush.android.STATUS";
    public static int a = 5;
    private static final Integer b = 0;
    public static final String ACTION_RICHPUSH_CALLBACK = "cn.jpush.android.intent.ACTION_RICHPUSH_CALLBACK";

    public static void init(Context context) {
        Logger.dd("JPushInterface", "action:init - sdkVersion:3.3.4, buildId:36");
        JPushInterface.checkContext(context);
        boolean bl = cn.jpush.android.i.a.g(context);
        if (!bl) {
            return;
        }
        cn.jpush.android.a.d(context);
        JCoreHelper.runActionWithService(context, "JPUSH", "init", null);
        c.a().b(context);
    }

    public static void resumePush(Context context) {
        Logger.dd("JPushInterface", "action:resumePush");
        JPushInterface.checkContext(context);
        JCoreHelper.runActionWithService(context, "JPUSH", "resume", null);
        c.a().c(context);
    }

    public static void stopPush(Context context) {
        Logger.dd("JPushInterface", "action:stopPush");
        JPushInterface.checkContext(context);
        JCoreHelper.runActionWithService(context, "JPUSH", "stop", null);
        c.a().d(context);
    }

    public static boolean isPushStopped(Context context) {
        JPushInterface.checkContext(context);
        return cn.jpush.android.cache.a.b(context) == 1;
    }

    public static void setDebugMode(boolean bl) {
        JCoreManager.setDebugMode((boolean)bl);
    }

    public static void setChannel(Context context, String string) {
        JCoreHelper.setChannel(context, string);
    }

    public static void setPushTime(Context context, Set<Integer> set, int n, int n2) {
        JPushInterface.checkContext(context);
        if (!cn.jpush.android.i.a.a(context)) {
            Logger.dd("JPushInterface", "\u68c0\u6d4b\u5230\u5f53\u524d\u6ca1\u6709\u7f51\u7edc\u3002\u6b64\u52a8\u4f5c\u5c06\u5728\u6709\u7f51\u7edc\u65f6\u81ea\u52a8\u7ee7\u7eed\u6267\u884c\u3002");
        }
        if (null == set) {
            Bundle bundle = new Bundle();
            bundle.putString("time", "0123456_0^23");
            JCoreHelper.runActionWithService(context, "JPUSH", "pushtime", bundle);
            return;
        }
        if (set.size() == 0 || set.isEmpty()) {
            JCoreHelper.runActionWithService(context, "JPUSH", "disable_push", null);
            return;
        }
        if (n > n2) {
            Logger.ee("JPushInterface", "Invalid time format - startHour should less than endHour");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n3 : set) {
            if (n3 > 6 || n3 < 0) {
                Logger.ee("JPushInterface", "Invalid day format - " + n3);
                return;
            }
            stringBuilder.append(n3);
        }
        stringBuilder.append("_");
        stringBuilder.append(n);
        stringBuilder.append("^");
        stringBuilder.append(n2);
        Bundle bundle = new Bundle();
        bundle.putString("time", stringBuilder.toString());
        JCoreHelper.runActionWithService(context, "JPUSH", "pushtime", bundle);
    }

    public static void setSilenceTime(Context context, int n, int n2, int n3, int n4) {
        JPushInterface.checkContext(context);
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n2 > 59 || n4 > 59 || n3 > 23 || n > 23) {
            Logger.ee("JPushInterface", "Invalid parameter format, startHour and endHour should between 0 ~ 23, startMins and endMins should between 0 ~ 59. ");
            return;
        }
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            Bundle bundle = new Bundle();
            bundle.putString("time", "");
            JCoreHelper.runActionWithService(context, "JPUSH", "silenceTime", bundle);
            Logger.dd("JPushInterface", "Remove the silence time!");
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("startHour", n);
            jSONObject.put("startMins", n2);
            jSONObject.put("endHour", n3);
            jSONObject.put("endtMins", n4);
            Bundle bundle = new Bundle();
            bundle.putString("time", jSONObject.toString());
            JCoreHelper.runActionWithService(context, "JPUSH", "silenceTime", bundle);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static String getRegistrationID(Context context) {
        JPushInterface.checkContext(context);
        return JCoreHelper.getRegistrationID(context);
    }

    private static void checkContext(Context context) {
        if (null == context) {
            throw new IllegalArgumentException("NULL context");
        }
        cn.jpush.android.a.a = context.getApplicationContext();
    }

    public static String getUdid(Context context) {
        JPushInterface.checkContext(context);
        return JCoreHelper.getDeviceId(context);
    }

    public static void setLatestNotificationNumber(Context context, int n) {
        JPushInterface.checkContext(context);
        Logger.dd("JPushInterface", "action:setLatestNotificationNumber : " + n);
        if (n <= 0) {
            Logger.ee("JPushInterface", "maxNum should > 0, Give up action..");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("num", n);
        JCoreHelper.runActionWithService(context, "JPUSH", "max_num", bundle);
    }

    public static void clearAllNotifications(Context context) {
        JPushInterface.checkContext(context);
        JCoreHelper.runActionWithService(context, "JPUSH", "clear_all_notify", null);
    }

    public static void clearNotificationById(Context context, int n) {
        JPushInterface.checkContext(context);
        if (n <= 0) {
            Logger.ee("JPushInterface", "Invalid notificationId, Give up action..");
            return;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancel(n);
    }

    public static void setDefaultPushNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
        if (null == pushNotificationBuilder) {
            throw new IllegalArgumentException("NULL notification");
        }
        Bundle bundle = new Bundle();
        bundle.putInt("buidler_id", b.intValue());
        bundle.putString("buidler_string", pushNotificationBuilder.toString());
        JCoreHelper.runActionWithService(cn.jpush.android.a.a, "JPUSH", "set_custom_notify", bundle);
    }

    public static void setPushNotificationBuilder(Integer n, PushNotificationBuilder pushNotificationBuilder) {
        Logger.vv("JPushInterface", "action:setPushNotificationBuilder - id:" + n);
        if (null == pushNotificationBuilder) {
            throw new IllegalArgumentException("NULL pushNotificationBuilder");
        }
        if (n < 1) {
            Logger.ee("JPushInterface", "id should be larger than 0");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("buidler_id", n.intValue());
        bundle.putString("buidler_string", pushNotificationBuilder.toString());
        JCoreHelper.runActionWithService(cn.jpush.android.a.a, "JPUSH", "set_custom_notify", bundle);
    }

    @Deprecated
    public void setAliasAndTags(Context context, String string, Set<String> set) {
        JPushInterface.checkContext(context);
        TagAliasCallback tagAliasCallback = null;
        cn.jpush.android.g.a.a(context, string, set, tagAliasCallback, 0, 0);
    }

    @Deprecated
    public static void setAliasAndTags(Context context, String string, Set<String> set, TagAliasCallback tagAliasCallback) {
        JPushInterface.checkContext(context);
        cn.jpush.android.g.a.a(context, string, set, tagAliasCallback, 0, 0);
    }

    @Deprecated
    public static void setTags(Context context, Set<String> set, TagAliasCallback tagAliasCallback) {
        JPushInterface.checkContext(context);
        JPushInterface.setAliasAndTags(context, null, set, tagAliasCallback);
    }

    @Deprecated
    public static void setAlias(Context context, String string, TagAliasCallback tagAliasCallback) {
        JPushInterface.checkContext(context);
        JPushInterface.setAliasAndTags(context, string, null, tagAliasCallback);
    }

    public static Set<String> filterValidTags(Set<String> set) {
        return cn.jpush.android.g.a.a(set);
    }

    public static void setTags(Context context, int n, Set<String> set) {
        JPushInterface.checkContext(context);
        cn.jpush.android.g.a.a(context, n, set, 1, 2);
    }

    public static void addTags(Context context, int n, Set<String> set) {
        JPushInterface.checkContext(context);
        cn.jpush.android.g.a.a(context, n, set, 1, 1);
    }

    public static void deleteTags(Context context, int n, Set<String> set) {
        JPushInterface.checkContext(context);
        cn.jpush.android.g.a.a(context, n, set, 1, 3);
    }

    public static void cleanTags(Context context, int n) {
        JPushInterface.checkContext(context);
        cn.jpush.android.g.a.a(context, n, new HashSet<String>(), 1, 4);
    }

    public static void getAllTags(Context context, int n) {
        JPushInterface.checkContext(context);
        cn.jpush.android.g.a.a(context, n, new HashSet<String>(), 1, 5);
    }

    public static void checkTagBindState(Context context, int n, String string) {
        JPushInterface.checkContext(context);
        HashSet<String> hashSet = null;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            hashSet = new HashSet<String>();
            hashSet.add(string);
        }
        cn.jpush.android.g.a.a(context, n, hashSet, 1, 6);
    }

    public static void setAlias(Context context, int n, String string) {
        JPushInterface.checkContext(context);
        cn.jpush.android.g.a.a(context, n, string, 2, 2);
    }

    public static void deleteAlias(Context context, int n) {
        JPushInterface.checkContext(context);
        cn.jpush.android.g.a.a(context, n, null, 2, 3);
    }

    public static void getAlias(Context context, int n) {
        JPushInterface.checkContext(context);
        cn.jpush.android.g.a.a(context, n, null, 2, 5);
    }

    public static void setMobileNumber(Context context, int n, String string) {
        JPushInterface.checkContext(context);
        h.a().a(context, n, string);
    }

    public static void reportNotificationOpened(Context context, String string) {
        JPushInterface.checkContext(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            Logger.ee("JPushInterface", "The msgId is not valid - " + string);
        }
        g.a(string, 1028, context);
    }

    public static void reportNotificationOpened(Context context, String string, byte by) {
        JPushInterface.checkContext(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            Logger.ee("JPushInterface", "The msgId is not valid - " + string);
        }
        g.a(string, "", by, 1000, context);
    }

    @Deprecated
    public static boolean getConnectionState(Context context) {
        JPushInterface.checkContext(context);
        return JCoreManager.getConnectionState((Context)context);
    }

    public static void onResume(Context context) {
        JCoreHelper.saEvent(context, "resume", null);
    }

    public static void onPause(Context context) {
        JCoreHelper.saEvent(context, "pause", null);
    }

    public static void onFragmentResume(Context context, String string) {
        JCoreHelper.saEvent(context, "f_resume", string);
    }

    public static void onFragmentPause(Context context, String string) {
        JCoreHelper.saEvent(context, "f_pause", string);
    }

    public static void onKillProcess(Context context) {
        JCoreHelper.saEvent(context, "kill", null);
    }

    public static void setStatisticsSessionTimeout(long l2) {
    }

    public static void setStatisticsEnable(boolean bl) {
    }

    public static void initCrashHandler(Context context) {
        JPushInterface.checkContext(context);
        JCoreManager.initCrashHandler((Context)context);
    }

    public static void stopCrashHandler(Context context) {
        JPushInterface.checkContext(context);
        JCoreManager.stopCrashHandler((Context)context);
    }

    public static void addLocalNotification(Context context, JPushLocalNotification jPushLocalNotification) {
        JPushInterface.checkContext(context);
        d.a(context, jPushLocalNotification);
    }

    public static void removeLocalNotification(Context context, long l2) {
        JPushInterface.checkContext(context);
        d.a(context, l2);
    }

    public static void clearLocalNotifications(Context context) {
        JPushInterface.checkContext(context);
        d.a(context);
    }

    private static boolean checkLengthOfTags(String string) {
        int n = 0;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            n += string.getBytes().length;
        }
        Logger.v("JPushInterface", "tags length:" + n);
        return n <= 7000;
    }

    public static String getStringTags(Set<String> set) {
        return cn.jpush.android.g.a.b(set);
    }

    private static void setDefaultNotifactionNumber(Context context) {
        JPushInterface.setLatestNotificationNumber(context, a);
    }

    public static void requestPermission(Context context) {
        if (context == null) {
            Logger.ww("JPushInterface", "[requestPermission] unexcepted - context was null");
            return;
        }
        JCoreManager.requestPermission((Context)context);
    }

    public static void setDaemonAction(String string) {
    }

    public static void setPowerSaveMode(Context context, boolean bl) {
    }

    public static void setGeofenceInterval(Context context, long l2) {
        JPushInterface.checkContext(context);
        if (l2 < 180000L || l2 > 86400000L) {
            Logger.ee("JPushInterface", "Invalid interval, it should be a ms number between 3 mins and 1 day!");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("interval", l2);
        JCoreHelper.runActionWithService(context, "JPUSH", "geo_interval", bundle);
    }

    public static void setMaxGeofenceNumber(Context context, int n) {
        JPushInterface.checkContext(context);
        if (n < 1 || n > 100) {
            Logger.ee("JPushInterface", "Invalid maxNumber,it should be a number between 1 and 100!");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("num", n);
        JCoreHelper.runActionWithService(context, "JPUSH", "geo_fence_max_num", bundle);
    }

    public static void deleteGeofence(Context context, String string) {
        JPushInterface.checkContext(context);
        Bundle bundle = new Bundle();
        bundle.putString("id", string);
        JCoreHelper.runActionWithService(context, "JPUSH", "delete_geo_fence", bundle);
    }

    private static void taq() {
        cn.jpush.android.a.c();
    }

    static {
        JCoreManager.addDispatchAction((String)"JPUSH", (String)f.class.getName());
    }

    public static class ErrorCode {
        public static int a = 0;
        public static int b = 6001;
        public static int c = 6002;
        public static int d = 6003;
        public static int e = 6004;
        public static int f = 6005;
        public static int g = 6006;
        public static int h = 6007;
        public static int i = 6008;
        public static int j = 6009;
        public static int k = 6010;
        public static int l = 6011;
        public static int m = 6012;
        public static int n = 6013;
        public static int o = 6014;
        public static int p = 6015;
        public static int q = 6016;
        public static int r = 6017;
        public static int s = 6018;
        public static int t = 6019;
        public static int u = 6020;
        public static int v = 6021;
        public static int w = 6022;
        public static int x = 6023;
        public static int y = 6024;
        public static int z = 6025;
    }
}

