/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.WindowManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.jpush.android.c.d;
import cn.jpush.android.helper.Logger;
import cn.jpush.android.j.a.b;
import cn.jpush.android.j.a.f;
import cn.jpush.android.ui.a;

public class FullScreenView
extends LinearLayout {
    private static final String TAG = "FullScreenView";
    private final Context mContext;
    private WebView mWebView;
    private RelativeLayout rlTitleBar;
    private TextView tvTitle;
    private ImageButton imgBtnBack;
    private ProgressBar pushPrograssBar;
    public static f webViewHelper = null;
    private View.OnClickListener btnBackClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (null != FullScreenView.this.mContext) {
                ((Activity)FullScreenView.this.mContext).onBackPressed();
            }
        }
    };

    public FullScreenView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
    }

    public void initModule(Context context, d d2) {
        String string = d2.O;
        this.setFocusable(true);
        this.mWebView = (WebView)this.findViewById(this.getResources().getIdentifier("fullWebView", "id", context.getPackageName()));
        this.rlTitleBar = (RelativeLayout)this.findViewById(this.getResources().getIdentifier("rlRichpushTitleBar", "id", context.getPackageName()));
        this.tvTitle = (TextView)this.findViewById(this.getResources().getIdentifier("tvRichpushTitle", "id", context.getPackageName()));
        this.imgBtnBack = (ImageButton)this.findViewById(this.getResources().getIdentifier("imgRichpushBtnBack", "id", context.getPackageName()));
        this.pushPrograssBar = (ProgressBar)this.findViewById(this.getResources().getIdentifier("pushPrograssBar", "id", context.getPackageName()));
        if (null == this.mWebView || null == this.rlTitleBar || null == this.tvTitle || null == this.imgBtnBack) {
            Logger.ee(TAG, "Please use default code in jpush_webview_layout.xml!");
            ((Activity)this.mContext).finish();
        }
        if (1 == d2.R) {
            this.rlTitleBar.setVisibility(8);
            ((Activity)context).getWindow().setFlags(1024, 1024);
        } else {
            this.tvTitle.setText((CharSequence)string);
            this.imgBtnBack.setOnClickListener(this.btnBackClickListener);
        }
        this.mWebView.setScrollbarFadingEnabled(true);
        this.mWebView.setScrollBarStyle(0x2000000);
        WebSettings webSettings = this.mWebView.getSettings();
        cn.jpush.android.i.a.a(webSettings);
        cn.jpush.android.i.a.a(this.mWebView);
        webSettings.setSavePassword(false);
        webViewHelper = new f(context, d2);
        if (Build.VERSION.SDK_INT >= 17) {
            Logger.dd(TAG, "Android sdk version greater than or equal to 17, Java\u2014Js interact by annotation!");
            this.reflectAddJsInterface();
        }
        this.mWebView.setWebChromeClient((WebChromeClient)new cn.jpush.android.j.a.a("JPushWeb", b.class, this.pushPrograssBar, this.tvTitle));
        this.mWebView.setWebViewClient((WebViewClient)new a(d2, context));
        b.setWebViewHelper(webViewHelper);
    }

    private void reflectAddJsInterface() {
        Object[] objectArray = new Object[2];
        Class[] classArray = new Class[2];
        objectArray[0] = webViewHelper;
        objectArray[1] = "JPushWeb";
        classArray[0] = Object.class;
        classArray[1] = String.class;
        try {
            cn.jpush.android.i.d.a(this.mWebView, "addJavascriptInterface", classArray, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.e(TAG, "addJavascriptInterface failed:" + exception.toString());
        }
    }

    public boolean webviewCanGoBack() {
        if (null != this.mWebView) {
            return this.mWebView.canGoBack();
        }
        return false;
    }

    public void webviewGoBack() {
        if (null != this.mWebView) {
            this.mWebView.goBack();
        }
    }

    public void loadUrl(String string) {
        if (this.mWebView != null) {
            Logger.d(TAG, "loadUrl:" + string);
            this.mWebView.loadUrl(string);
        }
    }

    public void resume() {
        if (null != this.mWebView) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.mWebView.onResume();
            }
            b.setWebViewHelper(webViewHelper);
        }
    }

    public void pause() {
        if (null != this.mWebView && Build.VERSION.SDK_INT >= 11) {
            this.mWebView.onPause();
        }
    }

    public void destory() {
        this.removeAllViews();
        if (this.mWebView != null) {
            this.mWebView.removeAllViews();
            this.mWebView.clearSslPreferences();
            this.mWebView.destroy();
            this.mWebView = null;
        }
    }

    public void showTitleBar() {
        if (this.rlTitleBar != null && this.rlTitleBar.getVisibility() == 8) {
            this.rlTitleBar.setVisibility(0);
            this.quitFullScreen();
            this.imgBtnBack.setOnClickListener(this.btnBackClickListener);
            if (this.mWebView != null) {
                this.mWebView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (FullScreenView.this.mWebView != null) {
                            FullScreenView.this.mWebView.clearHistory();
                        }
                    }
                }, 1000L);
            }
        }
    }

    private void quitFullScreen() {
        try {
            WindowManager.LayoutParams layoutParams = ((Activity)this.mContext).getWindow().getAttributes();
            layoutParams.flags &= 0xFFFFFBFF;
            ((Activity)this.mContext).getWindow().setAttributes(layoutParams);
            ((Activity)this.mContext).getWindow().clearFlags(512);
        }
        catch (Exception exception) {
            Logger.w(TAG, "quitFullScreen errno");
        }
    }
}

