/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.api.utils;

import cn.jiguang.api.JResponse;
import cn.jiguang.aq.d;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferUtils {
    private static final String TAG = "ByteBufferUtils";
    public static final int ERROR_CODE = 10000;

    public static int getInt(ByteBuffer byteBuffer, JResponse jResponse) {
        try {
            return byteBuffer.getInt();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            BufferUnderflowException bufferUnderflowException2 = bufferUnderflowException;
            ByteBufferUtils.onException(bufferUnderflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            BufferOverflowException bufferOverflowException2 = bufferOverflowException;
            ByteBufferUtils.onException(bufferOverflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ByteBufferUtils.onException(exception.fillInStackTrace(), jResponse, byteBuffer);
        }
        if (jResponse != null) {
            jResponse.code = 10000;
        }
        return -1;
    }

    public static short getShort(ByteBuffer byteBuffer, JResponse jResponse) {
        try {
            return byteBuffer.getShort();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            BufferUnderflowException bufferUnderflowException2 = bufferUnderflowException;
            ByteBufferUtils.onException(bufferUnderflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            BufferOverflowException bufferOverflowException2 = bufferOverflowException;
            ByteBufferUtils.onException(bufferOverflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ByteBufferUtils.onException(exception.fillInStackTrace(), jResponse, byteBuffer);
        }
        if (jResponse != null) {
            jResponse.code = 10000;
        }
        return -1;
    }

    public static ByteBuffer get(ByteBuffer byteBuffer, byte[] object, JResponse jResponse) {
        try {
            return byteBuffer.get((byte[])object);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            object = bufferUnderflowException;
            ByteBufferUtils.onException(bufferUnderflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            object = bufferOverflowException;
            ByteBufferUtils.onException(bufferOverflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (Exception exception) {
            object = exception;
            ByteBufferUtils.onException(exception.fillInStackTrace(), jResponse, byteBuffer);
        }
        if (jResponse != null) {
            jResponse.code = 10000;
        }
        return null;
    }

    public static Byte get(ByteBuffer byteBuffer, JResponse jResponse) {
        try {
            return byteBuffer.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            BufferUnderflowException bufferUnderflowException2 = bufferUnderflowException;
            ByteBufferUtils.onException(bufferUnderflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            BufferOverflowException bufferOverflowException2 = bufferOverflowException;
            ByteBufferUtils.onException(bufferOverflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ByteBufferUtils.onException(exception.fillInStackTrace(), jResponse, byteBuffer);
        }
        if (jResponse != null) {
            jResponse.code = 10000;
        }
        return null;
    }

    public static long getLong(ByteBuffer byteBuffer, JResponse jResponse) {
        try {
            return byteBuffer.getLong();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            BufferUnderflowException bufferUnderflowException2 = bufferUnderflowException;
            ByteBufferUtils.onException(bufferUnderflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            BufferOverflowException bufferOverflowException2 = bufferOverflowException;
            ByteBufferUtils.onException(bufferOverflowException.fillInStackTrace(), jResponse, byteBuffer);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ByteBufferUtils.onException(exception.fillInStackTrace(), jResponse, byteBuffer);
        }
        if (jResponse != null) {
            jResponse.code = 10000;
        }
        return 0L;
    }

    private static void onException(Throwable throwable, JResponse jResponse, ByteBuffer byteBuffer) {
        ByteBufferUtils.generalExtraStr(throwable, jResponse, byteBuffer);
    }

    private static String generalExtraStr(Throwable object, JResponse object2, ByteBuffer object3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object2 != null) {
            stringBuilder.append(((JResponse)object2).toString());
            stringBuilder.append("|bytebuffer:" + (object3 == null ? "byteBuffer is null" : ((ByteBuffer)object3).toString()));
        }
        d.f(TAG, "byteBuffer info:" + stringBuilder.toString());
        try {
            object2 = new StringWriter();
            object3 = new PrintWriter((Writer)object2);
            ((Throwable)object).printStackTrace((PrintWriter)object3);
            object = ((StringWriter)object2).toString();
            d.f(TAG, "parse data error stackTrace:" + (String)object);
        }
        catch (Exception exception) {}
        return stringBuilder.toString();
    }
}

