/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.connect.common;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import com.tencent.connect.auth.QQAuth;
import com.tencent.connect.auth.QQToken;
import com.tencent.connect.common.AssistActivity;
import com.tencent.open.TDialog;
import com.tencent.open.a.f;
import com.tencent.open.utils.Global;
import com.tencent.open.utils.HttpUtils;
import com.tencent.open.utils.SystemUtils;
import com.tencent.open.utils.Util;
import com.tencent.tauth.IRequestListener;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.UiError;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseApi {
    private static final String TAG = "openSDK_LOG.BaseApi";
    private static final String KEY_REQUEST_CODE = "key_request_code";
    protected static final String DEFAULT_PF = "openmobile_android";
    protected static final String PREFERENCE_PF = "pfStore";
    protected static final String ACTIVITY_ENCRY_TOKEN = "com.tencent.open.agent.EncryTokenActivity";
    protected static final String ACTIVITY_AGENT = "com.tencent.open.agent.AgentActivity";
    protected static final String ACTION_CHECK_TOKEN = "action_check_token";
    protected static final String PARAM_ENCRY_EOKEN = "encry_token";
    private static final int MSG_COMPLETE = 0;
    protected QQAuth mQQAuth;
    protected QQToken mToken;
    public static String registerChannel = null;
    public static String installChannel = null;
    public static String businessId = null;
    public static boolean isOEM = false;
    protected static final String VERSION = "android";
    protected static final String PLATFORM = "desktop_m_qq";
    protected ProgressDialog mProgressDialog;

    public BaseApi(QQAuth qQAuth, QQToken qQToken) {
        this.mQQAuth = qQAuth;
        this.mToken = qQToken;
    }

    public BaseApi(QQToken qQToken) {
        this(null, qQToken);
    }

    protected Bundle composeCGIParams() {
        Bundle bundle = new Bundle();
        bundle.putString("format", "json");
        bundle.putString("status_os", Build.VERSION.RELEASE);
        bundle.putString("status_machine", Build.MODEL);
        bundle.putString("status_version", Build.VERSION.SDK);
        bundle.putString("sdkv", "3.2.1");
        bundle.putString("sdkp", "a");
        if (this.mToken != null && this.mToken.isSessionValid()) {
            bundle.putString("access_token", this.mToken.getAccessToken());
            bundle.putString("oauth_consumer_key", this.mToken.getAppId());
            bundle.putString("openid", this.mToken.getOpenId());
            bundle.putString("appid_for_getting_config", this.mToken.getAppId());
        }
        SharedPreferences sharedPreferences = Global.getContext().getSharedPreferences(PREFERENCE_PF, 0);
        if (isOEM) {
            bundle.putString("pf", "desktop_m_qq-" + installChannel + "-" + VERSION + "-" + registerChannel + "-" + businessId);
        } else {
            String string = sharedPreferences.getString("pf", DEFAULT_PF);
            bundle.putString("pf", string);
        }
        return bundle;
    }

    protected String getCommonDownloadQQUrl(String string) {
        Bundle bundle = this.composeCGIParams();
        StringBuilder stringBuilder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString("need_version", string);
        }
        stringBuilder.append("http://openmobile.qq.com/oauth2.0/m_jump_by_version?");
        stringBuilder.append(HttpUtils.encodeUrl(bundle));
        return stringBuilder.toString();
    }

    protected Bundle composeActivityParams() {
        String string;
        Bundle bundle = new Bundle();
        bundle.putString("appid", this.mToken.getAppId());
        if (this.mToken.isSessionValid()) {
            bundle.putString("keystr", this.mToken.getAccessToken());
            bundle.putString("keytype", "0x80");
        }
        if ((string = this.mToken.getOpenId()) != null) {
            bundle.putString("hopenid", string);
        }
        bundle.putString("platform", "androidqz");
        SharedPreferences sharedPreferences = Global.getContext().getSharedPreferences(PREFERENCE_PF, 0);
        if (isOEM) {
            bundle.putString("pf", "desktop_m_qq-" + installChannel + "-" + VERSION + "-" + registerChannel + "-" + businessId);
        } else {
            String string2 = sharedPreferences.getString("pf", DEFAULT_PF);
            bundle.putString("pf", string2);
            bundle.putString("pf", DEFAULT_PF);
        }
        bundle.putString("sdkv", "3.2.1");
        bundle.putString("sdkp", "a");
        return bundle;
    }

    private Intent getAssitIntent(Activity activity, Intent intent) {
        Intent intent2 = new Intent(activity.getApplicationContext(), AssistActivity.class);
        intent2.putExtra("is_login", true);
        intent2.putExtra("openSDK_LOG.AssistActivity.ExtraIntent", (Parcelable)intent);
        return intent2;
    }

    protected void startAssistActivity(Activity activity, int n2, Intent intent, boolean bl) {
        Intent intent2 = new Intent(activity.getApplicationContext(), AssistActivity.class);
        if (bl) {
            intent2.putExtra("is_qq_mobile_share", true);
        }
        intent2.putExtra("openSDK_LOG.AssistActivity.ExtraIntent", (Parcelable)intent);
        activity.startActivityForResult(intent2, n2);
    }

    protected void startAssistActivity(Activity activity, Bundle bundle, int n2, Intent intent) {
        Intent intent2 = new Intent(activity.getApplicationContext(), AssistActivity.class);
        intent2.putExtra("h5_share_data", bundle);
        intent2.putExtra("openSDK_LOG.AssistActivity.ExtraIntent", (Parcelable)intent);
        activity.startActivityForResult(intent2, n2);
    }

    protected void startAssitActivity(Activity activity, Intent intent, int n2) {
        intent.putExtra(KEY_REQUEST_CODE, n2);
        activity.startActivityForResult(this.getAssitIntent(activity, intent), n2);
    }

    protected void startAssitActivity(Fragment fragment, Intent intent, int n2) {
        intent.putExtra(KEY_REQUEST_CODE, n2);
        fragment.startActivityForResult(this.getAssitIntent((Activity)fragment.getActivity(), intent), n2);
    }

    protected boolean hasActivityForIntent(Intent intent) {
        if (intent != null) {
            return SystemUtils.isActivityExist(Global.getContext(), intent);
        }
        return false;
    }

    protected Intent getTargetActivityIntent(String string) {
        Intent intent = new Intent();
        if (Util.isTablet(Global.getContext())) {
            intent.setClassName("com.tencent.minihd.qq", string);
            if (SystemUtils.isActivityExist(Global.getContext(), intent)) {
                return intent;
            }
        }
        intent.setClassName("com.tencent.mobileqq", string);
        if (SystemUtils.isActivityExist(Global.getContext(), intent)) {
            return intent;
        }
        intent.setClassName("com.tencent.tim", string);
        if (SystemUtils.isActivityExist(Global.getContext(), intent)) {
            return intent;
        }
        return null;
    }

    protected void handleDownloadLastestQQ(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "--handleDownloadLastestQQ");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://qzs.qq.com/open/mobile/login/qzsjump.html?");
        stringBuilder.append(HttpUtils.encodeUrl(bundle));
        String string = stringBuilder.toString();
        TDialog tDialog = new TDialog((Context)activity, "", string, null, this.mToken);
        tDialog.show();
    }

    protected void showProgressDialog(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "\u8bf7\u7a0d\u5019";
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "\u6b63\u5728\u52a0\u8f7d...";
        }
        this.mProgressDialog = ProgressDialog.show((Context)context, (CharSequence)string, (CharSequence)string2);
        this.mProgressDialog.setCancelable(true);
    }

    protected Intent getAgentIntentWithTarget(String string) {
        Intent intent = new Intent();
        Intent intent2 = this.getTargetActivityIntent(string);
        if (intent2 == null) {
            intent = null;
        } else if (intent2.getComponent() != null) {
            intent.setClassName(intent2.getComponent().getPackageName(), ACTIVITY_AGENT);
        } else {
            intent = null;
        }
        return intent;
    }

    public void releaseResource() {
    }

    public class TempRequestListener
    implements IRequestListener {
        private final IUiListener mListener;
        private final Handler mHandler;

        public TempRequestListener(IUiListener iUiListener) {
            this.mListener = iUiListener;
            this.mHandler = new Handler(Global.getContext().getMainLooper()){

                public void handleMessage(Message message) {
                    if (message.what == 0) {
                        TempRequestListener.this.mListener.onComplete(message.obj);
                    } else {
                        TempRequestListener.this.mListener.onError(new UiError(message.what, (String)message.obj, null));
                    }
                }
            };
        }

        @Override
        public void onComplete(JSONObject jSONObject) {
            Message message = this.mHandler.obtainMessage();
            message.obj = jSONObject;
            message.what = 0;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onIOException(IOException iOException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = iOException.getMessage();
            message.what = -2;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onMalformedURLException(MalformedURLException malformedURLException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = malformedURLException.getMessage();
            message.what = -3;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onJSONException(JSONException jSONException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = jSONException.getMessage();
            message.what = -4;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onConnectTimeoutException(ConnectTimeoutException connectTimeoutException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = connectTimeoutException.getMessage();
            message.what = -7;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onSocketTimeoutException(SocketTimeoutException socketTimeoutException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = socketTimeoutException.getMessage();
            message.what = -8;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onNetworkUnavailableException(HttpUtils.NetworkUnavailableException networkUnavailableException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = networkUnavailableException.getMessage();
            message.what = -10;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onHttpStatusException(HttpUtils.HttpStatusException httpStatusException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = httpStatusException.getMessage();
            message.what = -9;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onUnknowException(Exception exception) {
            Message message = this.mHandler.obtainMessage();
            message.obj = exception.getMessage();
            message.what = -6;
            this.mHandler.sendMessage(message);
        }
    }
}

