var brightness;
var bvalue;
var setted= false;
var app = {

    // Application Constructor
    initialize: function() {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },
    onDeviceReady: function() {
        var uid = window.localStorage.getItem("token");
        app.loadQrcode();
        setInterval(function () {
            window.location.reload();
        },15000);

        brightness = cordova.plugins.brightness;
        if(brightness){
          brightness.getBrightness(function(val){
              bvalue = val;
          }, function(err){
            console.log(err);
          });
        }
        document.addEventListener("backbutton", function(e){
               e.preventDefault();
               app.backTo();
            }, false);

        window.plugins.preventscreenshot.disable(function(ret){}, function(ret){});
    },
    loadQrcode: function() {
        $.showLoading("加载中");
        V1Qrcode(function(ok, ret) {
            if (ok) {
              console.log(ret)
                if (ret.code == 200) {
                    $.hideLoading();
                    var qrcode = new QRCode(document.getElementById("qrcode"), {
                      text: ret.qrcode,
                      width: 200,
                      height: 200,
                      colorDark: "#000000",
                      colorLight: "#ffffff",
                      correctLevel: QRCode.CorrectLevel.L
                    });
                    if(!setted&&brightness){
                      brightness.setBrightness(1, function(ret){
                        console.log(ret);
                        setted = true;
                        brightness.setKeepScreenOn(true);
                      }, function(e){
                        console.log(e)
                      });
                    }
                } else {
                    $.hideLoading();
                    $.alert("请求失败，请稍后再试", "错误");
                }
            } else {
                $.hideLoading();
                $.alert("请求失败了:" + ret.status + "请稍后再试", "错误");
            }
        })
    },
    refresh:function(){
      V1Qrcode(function(ok, ret) {
            if (ok) {
                if (ret.code == 200) {
                    $.hideLoading();
                    $("#qrcode").html('');
                    var qrcode = new QRCode(document.getElementById("qrcode"), {
                      text: ret.qrcode,
                      width: 200,
                      height: 200,
                      colorDark: "#000000",
                      colorLight: "#ffffff",
                      correctLevel: QRCode.CorrectLevel.L
                    });
                } else {
                    $.hideLoading();
                    $.alert("请求失败，请稍后再试", "错误");
                }
            } else {
                $.hideLoading();
                $.alert("请求失败了:" + ret.status + "请稍后再试", "错误");
            }
        })
    },
    backTo:function(){
      if(brightness&&bvalue){
        brightness.setBrightness(bvalue, function(ret){
          brightness.setKeepScreenOn(false);
        }, function(e){
          console.log(e)
        });
      } 
      window.location.href='main.html';
    }
};
app.initialize();