package com.visionsmarts;

public class VSBarcodeReader {
    public static final int BARCODE_TYPE_CODABAR = 64;
    public static final int BARCODE_TYPE_CODE128 = 32;
    public static final int BARCODE_TYPE_CODE39 = 16;
    public static final int BARCODE_TYPE_CODE93 = 128;
    public static final int BARCODE_TYPE_EAN_13_UPC_A = 1;
    public static final int BARCODE_TYPE_EAN_8 = 2;
    public static final String BARCODE_TYPE_ID_CODABAR = "CODABAR";
    public static final String BARCODE_TYPE_ID_CODE128 = "CODE128";
    public static final String BARCODE_TYPE_ID_CODE39 = "CODE39";
    public static final String BARCODE_TYPE_ID_CODE93 = "CODE93";
    public static final String BARCODE_TYPE_ID_EAN_13_UPC_A = "EAN13";
    public static final String BARCODE_TYPE_ID_EAN_8 = "EAN8";
    public static final String BARCODE_TYPE_ID_ITF = "ITF";
    public static final String BARCODE_TYPE_ID_STD2OF5 = "STD2OF5";
    public static final String BARCODE_TYPE_ID_UPC_E = "UPCE";
    public static final int BARCODE_TYPE_INVALID = -1;
    public static final int BARCODE_TYPE_ITF = 8;
    public static final String BARCODE_TYPE_NAME_CODABAR = "Codabar";
    public static final String BARCODE_TYPE_NAME_CODE128 = "Code 128";
    public static final String BARCODE_TYPE_NAME_CODE39 = "Code 39";
    public static final String BARCODE_TYPE_NAME_CODE93 = "Code 93";
    public static final String BARCODE_TYPE_NAME_EAN_13_UPC_A = "EAN-13/UPC-A";
    public static final String BARCODE_TYPE_NAME_EAN_8 = "EAN-8";
    public static final String BARCODE_TYPE_NAME_ITF = "ITF";
    public static final String BARCODE_TYPE_NAME_STD2OF5 = "STD 2 of 5";
    public static final String BARCODE_TYPE_NAME_UPC_E = "UPC-E";
    public static final int BARCODE_TYPE_STD2OF5 = 256;
    public static final int BARCODE_TYPE_UPC_E = 4;

    public static class DecoderValues {
        public int evaluationDays;
        public int left;
        public Point lineEnd;
        public Point lineStart;
        public int right;
        public int type;

        public DecoderValues() {
            this.lineStart = new Point();
            this.lineEnd = new Point();
        }
    }

    public static class Point {
        public int x;
        public int y;
    }

    public static native int VSinit();

    public static native String decodeNextImage(byte[] bArr, int i, int i2, DecoderValues decoderValues);

    public static native String decodeNextImageOmnidirectional(byte[] bArr, int i, int i2, int i3, DecoderValues decoderValues);

    public static native int reset();

    public static native int setBlurryAcceptanceThresholdWithAF(double d);

    static {
        System.loadLibrary("VSBarcodeReader");
    }

    public static String format(String barcode, int type) {
        Object[] objArr;
        switch (type) {
            case BARCODE_TYPE_EAN_13_UPC_A /*1*/:
                if (barcode.substring(0, BARCODE_TYPE_EAN_13_UPC_A).equals("0")) {
                    objArr = new Object[BARCODE_TYPE_UPC_E];
                    objArr[0] = barcode.substring(BARCODE_TYPE_EAN_13_UPC_A, BARCODE_TYPE_EAN_8);
                    objArr[BARCODE_TYPE_EAN_13_UPC_A] = barcode.substring(BARCODE_TYPE_EAN_8, 7);
                    objArr[BARCODE_TYPE_EAN_8] = barcode.substring(7, 12);
                    objArr[3] = barcode.substring(12, 13);
                    return String.format("%s-%s-%s-%s", objArr);
                }
                return String.format("%s-%s-%s", new Object[]{barcode.substring(0, BARCODE_TYPE_EAN_13_UPC_A), barcode.substring(BARCODE_TYPE_EAN_13_UPC_A, 7), barcode.substring(7, 13)});
            case BARCODE_TYPE_EAN_8 /*2*/:
                objArr = new Object[BARCODE_TYPE_EAN_8];
                objArr[0] = barcode.substring(0, BARCODE_TYPE_UPC_E);
                objArr[BARCODE_TYPE_EAN_13_UPC_A] = barcode.substring(BARCODE_TYPE_UPC_E, BARCODE_TYPE_ITF);
                return String.format("%s-%s", objArr);
            case BARCODE_TYPE_UPC_E /*4*/:
                return String.format("%s-%s-%s", new Object[]{barcode.substring(0, BARCODE_TYPE_EAN_13_UPC_A), barcode.substring(BARCODE_TYPE_EAN_13_UPC_A, 7), barcode.substring(7, BARCODE_TYPE_ITF)});
            default:
                return barcode;
        }
    }
}
