/*
 * Decompiled with CFR 0.152.
 */
package com.mascloud.util;

public class HexDumper {
    private static final byte[] highDigits;
    private static final byte[] lowDigits;

    public static String getHexdump(byte[] buffer) {
        if (buffer == null) {
            return "[]";
        }
        int size = buffer.length;
        StringBuilder out = new StringBuilder(size * 3 + 3);
        out.append("[");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                out.append(" ");
            }
            int byteValue = buffer[i] & 0xFF;
            out.append((char)highDigits[byteValue]);
            out.append((char)lowDigits[byteValue]);
        }
        out.append("]");
        return out.toString();
    }

    public static void main(String[] args) {
        String s = HexDumper.getHexdump(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 99, 88, 127, -128, -1});
        System.out.println(s);
    }

    static {
        byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        byte[] high = new byte[256];
        byte[] low = new byte[256];
        for (int i = 0; i < 256; ++i) {
            high[i] = digits[i >>> 4];
            low[i] = digits[i & 0xF];
        }
        highDigits = high;
        lowDigits = low;
    }
}

