/*
 * Decompiled with CFR 0.152.
 */
package com.mascloud.util;

import com.ejtone.mars.transport.http.client.HttpClientHolder;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    public static CloseableHttpResponse post(String url, String dat, ContentType type) throws Exception {
        HttpPost post = new HttpPost(url);
        post.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        HttpEntity entity = EntityBuilder.create().setText(dat).setContentType(type).build();
        post.setEntity(entity);
        CloseableHttpClient client = HttpClientHolder.getInstance().getClient();
        CloseableHttpResponse resp = client.execute((HttpUriRequest)post);
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readHttpResponse(HttpResponse response) throws IOException {
        HttpEntity resEntity = response.getEntity();
        if (resEntity == null) {
            return null;
        }
        try {
            Charset charset = ContentType.getOrDefault((HttpEntity)resEntity).getCharset();
            String contentCharset = charset == null ? HTTP.DEF_CONTENT_CHARSET.name() : charset.name();
            byte[] data = EntityUtils.toByteArray((HttpEntity)resEntity);
            String string = new String(data, contentCharset);
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)resEntity);
        }
    }

    public static void safeClose(CloseableHttpResponse o) {
        if (o == null) {
            return;
        }
        if (o.getEntity() != null) {
            try {
                EntityUtils.consume((HttpEntity)o.getEntity());
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        try {
            o.close();
        }
        catch (Throwable t) {
            logger.error("", t);
        }
    }
}

