/*
 * Decompiled with CFR 0.152.
 */
package com.mascloud.util;

import com.mascloud.util.JsonUtil;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Field;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixUtil {
    private static final Logger logger = LoggerFactory.getLogger(MixUtil.class);
    public static final String __LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static final Logger datLogger = LoggerFactory.getLogger((String)"$$dat.logger");
    public static final Logger monLogger = LoggerFactory.getLogger((String)"$$mon.logger");
    public static final String INET_ADDR_ANY = "0.0.0.0";

    public static int roundUpToPowerOf2(int number) {
        return number > 1 ? Integer.highestOneBit(number - 1 << 1) : 1;
    }

    public static String mergeUrl(String baseUrl, String addUrl) {
        baseUrl = StringUtils.stripEnd((String)(baseUrl == null ? "" : baseUrl), (String)"/");
        addUrl = StringUtils.stripStart((String)(addUrl == null ? "" : addUrl), (String)"/");
        return baseUrl + '/' + addUrl;
    }

    public static String fileSuffix(String filename) {
        if (StringUtils.isBlank((String)filename)) {
            return "";
        }
        String[] s = filename.split("\\.");
        return s.length <= 1 ? "" : s[s.length - 1];
    }

    public static String parentPath(String url) {
        if (StringUtils.isBlank((String)url) || url.equals("/")) {
            return "/";
        }
        int i = (url = StringUtils.stripEnd((String)url, (String)"/")).lastIndexOf("/");
        if (i != -1) {
            return url.substring(0, i) + "/";
        }
        return "/";
    }

    public static String replaceUnderlineAndfirstToUpper(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        String[] arr = str.split("_");
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null || arr[i].length() == 0) continue;
            sb.append(Character.toTitleCase(arr[i].charAt(0))).append(arr[i].substring(1));
        }
        return sb.toString();
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void warnTimeout(long currVal) {
        MixUtil.warnTimeout(currVal, 5000L);
    }

    public static void warnTimeout(long currVal, long warnVal) {
        if (currVal < warnVal) {
            logger.warn("timeout value {} < {}ms, make sure it's your want", (Object)currVal, (Object)warnVal);
        }
    }

    public static void printStackTrace() {
        MixUtil.printStackTrace(logger);
    }

    public static void printStackTrace(Logger logger) {
        StackTraceElement[] elements;
        for (StackTraceElement element : elements = Thread.currentThread().getStackTrace()) {
            logger.info("{}", (Object)element.toString());
        }
    }

    public static String getStackTrace() {
        StackTraceElement[] elements;
        StringBuilder sb = new StringBuilder(1024);
        for (StackTraceElement element : elements = Thread.currentThread().getStackTrace()) {
            sb.append(element.toString()).append("\n");
        }
        return sb.toString();
    }

    public static void safeClose(Closeable o) {
        if (o == null) {
            return;
        }
        try {
            o.close();
        }
        catch (Throwable t) {
            logger.error("", t);
        }
    }

    public static final boolean mkdirs(String dir) {
        File f = new File(dir);
        return f.mkdirs();
    }

    public static String listToString(List<?> list) {
        return JsonUtil.toJsonString(list);
    }

    public static String arrayToString(Object[] array) {
        if (array == null || array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(array[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean objectEquals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static <T> List<List<T>> comp(List<T> list1, List<T> list2) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(2);
        if (list1 == null || list1.size() == 0) {
            result.add(new ArrayList<T>(list2));
            result.add(new ArrayList());
            return result;
        }
        if (list2 == null || list2.size() == 0) {
            result.add(new ArrayList());
            result.add(new ArrayList<T>(list1));
            return result;
        }
        ArrayList<T> listAdd = new ArrayList<T>();
        ArrayList<T> listRemoved = new ArrayList<T>(list1);
        for (T t : list2) {
            if (listRemoved.remove(t)) continue;
            listAdd.add(t);
        }
        result.add(listAdd);
        result.add(listRemoved);
        return result;
    }

    public static boolean beanEquals(Object obj1, Object obj2) {
        Field[] fieldArr2;
        if (null == obj1 && null != obj2 || null != obj1 && null == obj2) {
            return false;
        }
        if (null == obj1 && null == obj2) {
            return true;
        }
        if (obj1.equals(obj2)) {
            return true;
        }
        Field[] fieldArr1 = obj1.getClass().getDeclaredFields();
        if (fieldArr1.length != (fieldArr2 = obj2.getClass().getDeclaredFields()).length) {
            return false;
        }
        for (int i = 0; i < fieldArr1.length; ++i) {
            Object tmpObj2;
            Object tmpObj1;
            Field field1 = fieldArr1[i];
            Field field2 = fieldArr2[i];
            field1.setAccessible(true);
            field2.setAccessible(true);
            String typeName1 = field1.getType().getName();
            String typeName2 = field2.getType().getName();
            if (!StringUtils.equals((String)typeName1, (String)typeName2)) {
                return false;
            }
            try {
                tmpObj1 = field1.get(obj1);
                tmpObj2 = field2.get(obj2);
            }
            catch (Exception e) {
                return false;
            }
            if (null == tmpObj1 && null != tmpObj2 || null != tmpObj1 && null == tmpObj2) {
                return false;
            }
            if (null == tmpObj1 && null == tmpObj2 || !(String.class.getName().equals(typeName1) ? !((String)tmpObj1).equals((String)tmpObj2) : (Boolean.TYPE.getName().equals(typeName1) ? !((Boolean)tmpObj1).equals((Boolean)tmpObj2) : (Double.TYPE.getName().equals(typeName1) ? !((Double)tmpObj1).equals((Double)tmpObj2) : (Float.TYPE.getName().equals(typeName1) ? !((Float)tmpObj1).equals((Float)tmpObj2) : (Integer.TYPE.getName().equals(typeName1) ? !((Integer)tmpObj1).equals((Integer)tmpObj2) : (Long.TYPE.getName().equals(typeName1) ? !((Long)tmpObj1).equals((Long)tmpObj2) : (Character.TYPE.getName().equals(typeName1) ? !((Character)tmpObj1).equals((Character)tmpObj2) : !tmpObj1.toString().equals(tmpObj2.toString()))))))))) continue;
            return false;
        }
        return true;
    }

    public static String getLocalAddress() {
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                if (!ni.getName().equals("en0") && !ni.getName().equals("eth0")) continue;
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress i = ips.nextElement();
                    if (i instanceof Inet6Address) continue;
                    return i.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "00:00:00:00:00:00";
    }

    public static String getMac() {
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                byte[] macs;
                NetworkInterface ni = netInterfaces.nextElement();
                if (!ni.getName().equals("en0") && !ni.getName().equals("eth0") || (macs = ni.getHardwareAddress()) == null) continue;
                return String.format("%02x:%02x:%02x:%02x:%02x:%02x", macs[0] & 0xFF, macs[1] & 0xFF, macs[2] & 0xFF, macs[3] & 0xFF, macs[4] & 0xFF, macs[5] & 0xFF);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "00:00:00:00:00:00";
    }

    public static void getAllMacAdress() {
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                System.out.println("DisplayName: " + ni.getDisplayName());
                System.out.println("Name: " + ni.getName());
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress i = ips.nextElement();
                    if (i instanceof Inet6Address) {
                        System.out.println("IPv6: " + i.getHostAddress());
                        continue;
                    }
                    System.out.println("IPv4: " + i.getHostAddress());
                }
                byte[] macs = ni.getHardwareAddress();
                if (macs == null) continue;
                String mac = String.format("%02x:%02x:%02x:%02x:%02x:%02x", macs[0] & 0xFF, macs[1] & 0xFF, macs[2] & 0xFF, macs[3] & 0xFF, macs[4] & 0xFF, macs[5] & 0xFF);
                System.out.println("MAC:" + mac);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public static String getObjectIdentity(Object o) {
        return o.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    public static void checkTimeout(long currVal) {
        MixUtil.checkTimeout(currVal, 5000L);
    }

    public static void checkTimeout(long currVal, long warnVal) {
        if (currVal < warnVal) {
            logger.warn("timeout value {} < {}ms,make sure it's your want", (Object)currVal, (Object)warnVal);
        }
    }

    public static String uuid() {
        UUID uuid = UUID.randomUUID();
        long mostSigBits = uuid.getMostSignificantBits();
        long leastSigBits = uuid.getLeastSignificantBits();
        return MixUtil.digits(mostSigBits >> 32, 8) + MixUtil.digits(mostSigBits >> 16, 4) + MixUtil.digits(mostSigBits, 4) + MixUtil.digits(leastSigBits >> 48, 4) + MixUtil.digits(leastSigBits, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    public static long ipToLong(String strIp) {
        long[] ip = new long[4];
        int position1 = strIp.indexOf(".");
        int position2 = strIp.indexOf(".", position1 + 1);
        int position3 = strIp.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIp.substring(0, position1));
        ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIp.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static String longToIP(long longIp) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(longIp >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIp & 0xFFL));
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(MixUtil.getLocalAddress());
        System.out.println(MixUtil.getMac());
        MixUtil.getAllMacAdress();
    }
}

