/*
 * Decompiled with CFR 0.152.
 */
package com.mascloud.util;

import java.util.regex.Pattern;

public class MobileSection {
    private String regex = "^\\+?(\\(?0{0,2}(86)?\\)?)1(((\\d{2}|(44)\\d{2}|(0648)|(0647))\\d{8}))$";
    private Pattern pattern = Pattern.compile(this.regex);

    private MobileSection() {
    }

    public void update(String regex) {
        this.regex = regex;
        this.pattern = Pattern.compile(regex);
    }

    public boolean isMobile(String mobile) {
        return this.pattern.matcher(mobile).matches();
    }

    public static final MobileSection getInstance() {
        return InstanceHolder.instance;
    }

    public static void main(String[] args) {
        System.out.println(MobileSection.getInstance().isMobile("1440004150515"));
    }

    private static final class InstanceHolder {
        public static final MobileSection instance = new MobileSection();

        private InstanceHolder() {
        }
    }
}

