/*
 * Decompiled with CFR 0.152.
 */
package com.mascloud.util;

import com.mascloud.util.CharsetUtil;

public enum MsgFormat {
    asciiFormat(0, "ISO-8859-1"),
    cardFormat(3, "UTF-8"),
    binFormat(4, "UTF-8"),
    ucs2Format(8, "UTF-16BE"),
    gbkFormat(15, "GBK"),
    flashFormat(24, "UTF-16BE");

    private byte fmt;
    private String charset;

    private MsgFormat(byte fmt, String charset) {
        this.fmt = fmt;
        this.charset = charset;
    }

    public byte getFmt() {
        return this.fmt;
    }

    public String getCharset() {
        return this.charset;
    }

    public static MsgFormat parse(int fmt) {
        MsgFormat[] fmts;
        for (MsgFormat format : fmts = MsgFormat.values()) {
            if (format.fmt != fmt) continue;
            return format;
        }
        return gbkFormat;
    }

    public static String getCharset(int fmt) {
        return MsgFormat.parse((int)fmt).charset;
    }

    public String getContent(byte[] msgContent) {
        return CharsetUtil.newString(msgContent, MsgFormat.getCharset(this.fmt));
    }

    public byte[] getContent(String msgContent) {
        return CharsetUtil.getBytesUnchecked(msgContent, this.charset);
    }

    public String toReadableString(byte[] bytes) {
        if (this == asciiFormat || this == ucs2Format || this == flashFormat || this == gbkFormat) {
            return this.getContent(bytes);
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("[");
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(String.format("0x%02x ", bytes[i]));
        }
        sb.append("]");
        return sb.toString();
    }
}

