package com.supwisdom.dlpay.agent;

public enum AgentCode {
  SUCCESS("success", "成功"),
  FAIL("fail", "交易失败"),
  REFNO_NOT_EXISTS("refno_not_exists", "指定流水不存在"),
  ILLEGAL_DATA("illegal_data", "数据不合法，不能交易"),
  SERVER_INTERNAL_ERROR("server_internal_error", "交易系统错误"),
  REQUIRE_QUERY("require_query", "交易未完成，请查询"),
  WAIT_NOTIFY("wait_notify", "交易已发起，等待通知"),
  SHORT_OF_BALANCE("short_of_balance", "余额不足"),
  NOT_SUPPORT("not_support", "不支持功能"),
  COMMON_ERROR("common_error", "其它错误"),
  CONFIG_ERROR("config_error", "参数配置错误");
  AgentCode(String code, String msg) {
    this.code = code;
    this.msg = msg;
  }

  public String value() {
    return this.code;
  }

  public String message() {
    return this.msg;
  }

  private String code;
  private String msg;

  @Override
  public String toString() {
    return code;
  }
}
