package com.supwisdom.dlpay.agent.citizencard;

import com.supwisdom.dlpay.agent.AgentCode;
import org.springframework.data.util.Pair;

import java.util.ArrayList;
import java.util.List;


public class YnrccUtil {
  public static final String BANKCARD_BIND_TRANSCODE = "BC5510";
  public static final String BANKCARD_SIGN_TRANSCODE = "BC5511";
  public static final String BANKCARD_PAY_TRANSCODE = "BC5512";
  public static final String BANKCARD_PAYREFUND_TRANSCODE = "BC5513";
  public static final String BANKCARD_QUERYRESULT_TRANSCODE = "BC5514";
  public static final String BANKCARD_CHKFILE_TRANSCODE = "BC5515";
  public static final String BANKCARD_CHKMAKESURE_TRANSCODE = "BC5516";
  public static final String BANKCARD_BANKCARDLOSS_TRANSCODE = "BC5517";

  public static final String DLPAY_CATEGORIE = "C001"; //消费类别

  public static final String YNRCC_ANGENT_URL = "ynrcc.agent.url"; //农商行前置url
  public static final String YNRCC_SIGNKEY = "ynrcc.agent.signkey"; //农商行前置md5key
  public static final String YNRCC_MERCHANT_BANKCARDNO = "merchant.bankcardno";
  public static final String YNRCC_MERCHANT_BANKACCNAME = "merchant.bankaccname";

  public static final String PARAM_CONFIG_ERROR = "90000"; // 参数未配置
  public static final String PARAM_VALUE_ERROR = "90001"; // 参数值错误

  public static final int AGENT_CONNECT_TIMEOUT = 10;
  public static final int AGENT_READ_TIMEOUT = 10;
  public static final String TRANSTYPE_SIGNCARD = "1"; //签约
  public static final String TRANSTYPE_UNSIGNCARD = "2"; //解约

  public static final String CODE_SUCCESS = "0000"; //成功
  public static final String CODE_NOT_EXISTS = "0401"; //流水不存在
  public static final String CODE_EXCEPTION = "10000"; //异常
  public static final String NO_RECORDS_TODAY = "0406"; //当日无交易明细

  //查询接口返回的流水状态
  public static final String DTL_STATUS_SUCCESS = "0"; //成功
  public static final String DTL_STATUS_FAIL = "1"; //失败
  public static final String DTL_STATUS_REFUND = "2"; //已退款
  public static final String DTL_STATUS_PART_REFUND = "3"; //部分退款

  public static final int QUERY_MAX_COUNT = 3; //最大查询次数

  public static final String YNRCC_BILLS_DOWNLOAD_LASTDATE = "ynrcc.download.bills.lastdate";

  public static final List<Pair<AgentCode, YnrccRespCode>> errcode = new ArrayList<>(0);

  static {
    errcode.add(Pair.of(AgentCode.SUCCESS, new YnrccRespCode("0000", "成功")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0101", "手机号不一致")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0102", "无预留手机号")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0103", "证件类型不一致")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0104", "证件号码不一致")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0105", "户名不符")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0106", "卡状态异常")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0107", "无此卡号")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0108", "已存在签约信息,与签约证件号码不符")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0109", "已存在签约信息,与签约证件类型不符")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0110", "已存在签约信息,与签约户名不符")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0111", "已存在签约信息,与签约手机号不符")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0112", "卡已挂失")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0113", "卡已密码挂失")));

    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0201", "未进行银行卡绑定")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0202", "无效的交易类型")));
    
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0301", "未签约")));
    errcode.add(Pair.of(AgentCode.SHORT_OF_BALANCE, new YnrccRespCode("0302", "余额不足")));
    errcode.add(Pair.of(AgentCode.SERVER_INTERNAL_ERROR, new YnrccRespCode("0303", "MD5校验失败")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0304", "该卡号已经解约,不允许重复解约")));

    errcode.add(Pair.of(AgentCode.REFNO_NOT_EXISTS, new YnrccRespCode("0401", "原始流水不存在")));
    errcode.add(Pair.of(AgentCode.FAIL, new YnrccRespCode("0402", "原始流水未成功")));
    errcode.add(Pair.of(AgentCode.FAIL, new YnrccRespCode("0403", "原始流水已退款")));
    errcode.add(Pair.of(AgentCode.SHORT_OF_BALANCE, new YnrccRespCode("0404", "商户账户余额不足")));
    errcode.add(Pair.of(AgentCode.FAIL, new YnrccRespCode("0405", "不在退款时间范围内")));
    errcode.add(Pair.of(AgentCode.SUCCESS, new YnrccRespCode("0406", "当日无交易明细")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0407", "非大理市民卡,不允许交易")));
    errcode.add(Pair.of(AgentCode.FAIL, new YnrccRespCode("0408", "同一请求流水号不允许重复提交")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0409", "商户卡号为空")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0410", "商户户名错")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0411", "退款金额大于原代扣金额")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0412", "退款金额大于剩余可退金额")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0413", "不允许该类型的商户账户交易")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0414", "退款时请输入原应用系统唯一流水号")));
    errcode.add(Pair.of(AgentCode.ILLEGAL_DATA, new YnrccRespCode("0415", "交易金额大于单笔限额")));
    errcode.add(Pair.of(AgentCode.SERVER_INTERNAL_ERROR, new YnrccRespCode("0416", "通用限额未配置")));

    errcode.add(Pair.of(AgentCode.COMMON_ERROR, new YnrccRespCode("4444", "其他错误[{message}]")));
    errcode.add(Pair.of(AgentCode.REQUIRE_QUERY, new YnrccRespCode(CODE_EXCEPTION, "待查询")));
    errcode.add(Pair.of(AgentCode.SERVER_INTERNAL_ERROR, new YnrccRespCode(PARAM_CONFIG_ERROR, "{message}")));
    errcode.add(Pair.of(AgentCode.SERVER_INTERNAL_ERROR, new YnrccRespCode(PARAM_VALUE_ERROR, "{message}")));
  }


}
