package com.supwisdom.dlpay.api.annotation;

import com.supwisdom.dlpay.api.types.IDTypes;
import com.supwisdom.dlpay.api.validator.IDNoCheckValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

@Target({ElementType.TYPE, ElementType.ANNOTATION_TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = IDNoCheckValidator.class)
@Documented
public @interface IDNoCheck {
  String message() default "{constraintdescriptor.fieldmatch}";

  Class<?>[] groups() default {};

  Class<? extends Payload>[] payload() default {};

  /**
   * @return The idno field
   */
  String idno();

  /**
   * @return The idtype field
   */
  String idtype();

  /**
   * 证件类型字典
   *
   * @return
   */
  IDTypes value() default IDTypes.IDTYPE_LIST;
}