package com.supwisdom.dlpay.api.annotation;

import com.supwisdom.dlpay.api.validator.MobileNumberValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

@Constraint(validatedBy = {MobileNumberValidator.class})
@Documented
@Target({ElementType.ANNOTATION_TYPE, ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface MobileNumber {
  String message() default "手机号码不合法";

  Class<?>[] groups() default {};

  Class<? extends Payload>[] payload() default {};
}