package com.supwisdom.dlpay.api.dao;

import com.supwisdom.dlpay.api.domain.TCard;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface CardDao extends JpaRepository<TCard, String> {

  @Query("from TCard t where t.cardno=?1 and t.cardtype=?2")
  TCard findCardByCardnoAndCardtype(String cardno, String cardtype);

  @Query("from TCard t where t.userid=?1 and t.cardtype=?2 and t.status='normal' ")
  TCard findCardByUseridAndCardtype(String userid, String cardtype);

  @Query("from TCard t where t.userid=?1 and t.cardtype=?2 and t.cardphyid=?3 ")
  TCard findBankcardByCitizencard(String userid, String cardtype, String cardphyid);

}
