package com.supwisdom.dlpay.api.dao;

import com.supwisdom.dlpay.api.domain.TSourceType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by shuwei on 2019/4/9.
 */
@Repository
public interface SourceTypeDao extends JpaRepository<TSourceType, String> {
  TSourceType getBySourceType(String paytype);

  Page<TSourceType> findBySourceTypeContaining(String paytype, Pageable pageable);

  @Query("select t from TSourceType t")
  List<TSourceType> getConsumeSourceTypes();

  List<TSourceType> findByEnableAndTenantid(Boolean enabled, String tenantid);

  @Query("from TSourceType t where t.enable=true  and t.checkable=true and t.tenantid=?1 order by t.sourceType ")
  List<TSourceType> findNeedChecks(String tenantid);
}
