package com.supwisdom.dlpay.api.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import javax.validation.constraints.NotNull;

@Entity
@Table(name = "TB_CARD",
    indexes = {@Index(name = "tb_card_uk", columnList = "cardno,cardtype", unique = true)})
public class TCard {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "ID", nullable = false, length = 32)
  private String id;

  @Column(name = "CARDNO", nullable = false, length = 32)
  private String cardno;

  @Column(name = "CARDTYPE", nullable = false, length = 20)
  private String cardtype;

  @Column(name = "CARDPHYID", length = 20)
  private String cardphyid;

  @Column(name = "STATUS", nullable = false, length = 20)
  private String status; //normal/closed

  @Column(name = "TRANS_STATUS", nullable = false, length = 20)
  private String transStatus; //normal/loss/frozen/locked/abnormal/unuse

  @Column(name = "EXPIREDATE", length = 20)
  private String expiredate;

  @Column(name = "SIGNED", nullable = false, length = 10)
  private Boolean signed = false; //签约状态

  @Column(name = "USERID", nullable = false, length = 32)
  private String userid;

  @Column(name = "LASTSAVED", length = 20)
  private String lastsaved;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantid = "";

  public TCard() {
  }

  public TCard(String cardno, String cardtype, String cardphyid, String status, String transStatus, String expiredate, Boolean signed, String userid, String lastsaved) {
    this.cardno = cardno;
    this.cardtype = cardtype;
    this.cardphyid = cardphyid;
    this.status = status;
    this.transStatus = transStatus;
    this.expiredate = expiredate;
    this.signed = signed;
    this.userid = userid;
    this.lastsaved = lastsaved;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getCardno() {
    return cardno;
  }

  public void setCardno(String cardno) {
    this.cardno = cardno;
  }

  public String getCardtype() {
    return cardtype;
  }

  public void setCardtype(String cardtype) {
    this.cardtype = cardtype;
  }

  public String getCardphyid() {
    return cardphyid;
  }

  public void setCardphyid(String cardphyid) {
    this.cardphyid = cardphyid;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getTransStatus() {
    return transStatus;
  }

  public void setTransStatus(String transStatus) {
    this.transStatus = transStatus;
  }

  public String getExpiredate() {
    return expiredate;
  }

  public void setExpiredate(String expiredate) {
    this.expiredate = expiredate;
  }

  public Boolean getSigned() {
    return signed;
  }

  public void setSigned(Boolean signed) {
    this.signed = signed;
  }

  public String getUserid() {
    return userid;
  }

  public void setUserid(String userid) {
    this.userid = userid;
  }

  public String getLastsaved() {
    return lastsaved;
  }

  public void setLastsaved(String lastsaved) {
    this.lastsaved = lastsaved;
  }

  public String getTenantid() {
    return tenantid;
  }

  public void setTenantid(String tenantid) {
    this.tenantid = tenantid;
  }
}
