package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;

@Entity
@Table(name = "TB_USERDTL_DEBITCREDIT")
@IdClass(TDebitCreditDtlPK.class)
public class TDebitCreditDtl {

  @Id
  @Column(name = "REFNO", nullable = false, length = 32)
  private String refno;

  @Id
  @Column(name = "SEQNO", nullable = false, precision = 2)
  private Integer seqno;

  @Column(name = "settledate", length = 8)
  @Digits(integer = 8, fraction = 0)
  private String settleDate;

  @Column(name = "DRSUBJNO", length = 10)
  @NotNull
  private String drsubjno; //借方科目

  @Column(name = "DRACCNO", length = 32)
  @NotNull
  private String draccno;  //借方账号

  @Column(name = "AMOUNT", precision = 9, scale = 2)
  @NotNull
  private Double amount; //金额

  @Column(name = "CRSUBJNO", length = 10)
  @NotNull
  private String crsubjno; //贷方科目

  @Column(name = "CRACCNO", length = 32)
  @NotNull
  private String craccno;  //贷方账号

  @Column(name = "SUMMARY", length = 240)
  private String summary;  //摘要

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantid = "";


  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public Integer getSeqno() {
    return seqno;
  }

  public void setSeqno(Integer seqno) {
    this.seqno = seqno;
  }

  public String getDrsubjno() {
    return drsubjno;
  }

  public void setDrsubjno(String drsubjno) {
    this.drsubjno = drsubjno;
  }

  public String getDraccno() {
    return draccno;
  }

  public void setDraccno(String draccno) {
    this.draccno = draccno;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public String getCrsubjno() {
    return crsubjno;
  }

  public void setCrsubjno(String crsubjno) {
    this.crsubjno = crsubjno;
  }

  public String getCraccno() {
    return craccno;
  }

  public void setCraccno(String craccno) {
    this.craccno = craccno;
  }

  public String getSummary() {
    return summary;
  }

  public void setSummary(String summary) {
    this.summary = summary;
  }

  public String getSettleDate() {
    return settleDate;
  }

  public void setSettleDate(String settleDate) {
    this.settleDate = settleDate;
  }

  public String getTenantid() {
    return tenantid;
  }

  public void setTenantid(String tenantid) {
    this.tenantid = tenantid;
  }
}
