package com.supwisdom.dlpay.api.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Entity
@Table(name = "TB_SHOP_SOURCETYPE",
    indexes = {@Index(name = "shop_sourcetype_idx",
        columnList = "shopaccno, sourcetype, tenantid", unique = true)})
public class TShopSourceType implements Serializable {
  private static final long serialVersionUID = -5789612905074310179L;

  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "id")
  private String id;

  @Column(name = "SHOPACCNO", length = 10)
  @NotNull
  private String shopaccno;

  @Column(name = "SOURCETYPE", length = 20)
  @NotNull
  private String sourceType;

  @Column(name = "CONSUME_ENABLE", length = 10)
  @NotNull
  private boolean consumeEnable; //该商户下，此支付方式能否消费

  @Column(name = "ANONYMOUS_ENABLE", length = 10)
  @NotNull
  private boolean anonymousEnable; //该商户下，此支付方式能否匿名消费

  @Column(name = "REVERSE_ENABLE", length = 10)
  @NotNull
  private boolean reverseEnable; //该商户下，此支付方式能否冲正

  @Column(name = "CREATETIME", length = 14)
  private String createtime;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantid = "";

  public String getShopaccno() {
    return shopaccno;
  }

  public void setShopaccno(String shopaccno) {
    this.shopaccno = shopaccno;
  }

  public String getSourceType() {
    return sourceType;
  }

  public void setSourceType(String sourceType) {
    this.sourceType = sourceType;
  }

  public boolean getConsumeEnable() {
    return consumeEnable;
  }

  public void setConsumeEnable(boolean consumeEnable) {
    this.consumeEnable = consumeEnable;
  }

  public boolean getAnonymousEnable() {
    return anonymousEnable;
  }

  public void setAnonymousEnable(boolean anonymousEnable) {
    this.anonymousEnable = anonymousEnable;
  }

  public boolean getReverseEnable() {
    return reverseEnable;
  }

  public void setReverseEnable(boolean reverseEnable) {
    this.reverseEnable = reverseEnable;
  }

  public String getCreatetime() {
    return createtime;
  }

  public void setCreatetime(String createtime) {
    this.createtime = createtime;
  }

  public String getTenantid() {
    return tenantid;
  }

  public void setTenantid(String tenantid) {
    this.tenantid = tenantid;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }
}
