package com.supwisdom.dlpay.api.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Entity
@Table(name = "TB_SHOP_PAYTYPE_CONFIG",
    indexes = {@Index(name = "shop_sourceype_config_idx", unique = true,
        columnList = "shopaccno,sourcetype,configid,tenantid")})
public class TShopSourceTypeConfig implements Serializable {
  private static final long serialVersionUID = 135187738251025666L;

  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "CFGID", nullable = false, length = 32)
  private String cfgid;

  @Column(name = "SHOPACCNO", length = 10)
  @NotNull
  private String shopaccno;

  @Column(name = "SOURCETYPE", length = 20)
  @NotNull
  private String sourceType;

  @Column(name = "CONFIGID", length = 40)
  @NotNull
  private String configid;

  @Column(name = "CONFIG_VALUE", length = 2000)
  private String configValue;

  @Column(name = "CONFIG_NAME", length = 200)
  private String configName;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantid = "";

  public TShopSourceTypeConfig() {
  }

  public TShopSourceTypeConfig(String shopaccno, String sourceType, String configid, String configValue, String configName) {
    this.shopaccno = shopaccno;
    this.sourceType = sourceType;
    this.configid = configid;
    this.configValue = configValue;
    this.configName = configName;
  }

  public String getCfgid() {
    return cfgid;
  }

  public void setCfgid(String cfgid) {
    this.cfgid = cfgid;
  }

  public String getShopaccno() {
    return shopaccno;
  }

  public void setShopaccno(String shopaccno) {
    this.shopaccno = shopaccno;
  }

  public String getSourceType() {
    return sourceType;
  }

  public void setSourceType(String sourceType) {
    this.sourceType = sourceType;
  }

  public String getConfigid() {
    return configid;
  }

  public void setConfigid(String configid) {
    this.configid = configid;
  }

  public String getConfigValue() {
    return configValue;
  }

  public void setConfigValue(String configValue) {
    this.configValue = configValue;
  }

  public String getConfigName() {
    return configName;
  }

  public void setConfigName(String configName) {
    this.configName = configName;
  }

  public String getTenantid() {
    return tenantid;
  }

  public void setTenantid(String tenantid) {
    this.tenantid = tenantid;
  }
}
