package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;
import javax.validation.constraints.NotNull;

@Entity
@Table(name = "TB_SHOPDTL",
    indexes = {@Index(name = "shopdtl_accdate", columnList = "accdate"),
        @Index(name = "shopdtl_shopaccno", columnList = "shopaccno"),
        @Index(name = "shopdtl_transdate", columnList = "transdate"),
        @Index(name = "shopdtl_tenantid_idx", columnList = "tenantid"),
        @Index(name = "shopdtl_updateflag", columnList = "updatebala")})
public class TShopdtl {
  @Id
  @Column(name = "REFNO", length = 32, nullable = false)
  private String refno;

  @Column(name = "ACCDATE", length = 8)
  @NotNull
  private String accdate;

  @Column(name = "SHOPACCNO", length = 10)
  @NotNull
  private String shopaccno;

  @Column(name = "SHOPNAME", length = 200)
  private String shopname;

  @Column(name = "AMOUNT", scale = 2, precision = 15)
  @NotNull
  private Double amount;

  @Column(name = "TRANSDATE", length = 8)
  @NotNull
  private String transdate;

  @Column(name = "TRANSTIME", length = 6)
  @NotNull
  private String transtime;

  @Column(name = "TRANSCODE", precision = 8)
  private Integer transcode;

  @Column(name = "SOURCETYPE", length = 20)
  private String sourceType;

  @Column(name = "PAYINFO", length = 200)
  private String payInfo;

  @Column(name = "TRADEFLAG", length = 6)
  @NotNull
  private String tradeflag; // out - 支出 ， in - 收入

  @Column(name = "TRANSDESC", length = 240)
  private String transdesc; //交易描述

  @Column(name = "REVERSEFLAG", length = 10)
  private String reverseFlag;

  @Column(name = "STATUS", length = 20)
  @NotNull
  private String status;

  @Column(name = "updatebala")
  @NotNull
  private Boolean updateBala = false;

  @Column(name = "OPPOSITEACCNO", length = 64)
  private String oppositeAccNo;

  @Column(name = "OPPOSITEACCNAME", length = 200)
  private String oppositeAccName;

  @Column(name = "REMARK", length = 240)
  private String remark;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantid = "";

  @Column(name = "DTLTYPE", length = 20)
  private String dtltype;

  public String getDtltype() {
    return dtltype;
  }

  public void setDtltype(String dtltype) {
    this.dtltype = dtltype;
  }

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }

  public String getShopaccno() {
    return shopaccno;
  }

  public void setShopaccno(String shopaccno) {
    this.shopaccno = shopaccno;
  }

  public String getShopname() {
    return shopname;
  }

  public void setShopname(String shopname) {
    this.shopname = shopname;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public String getTransdate() {
    return transdate;
  }

  public void setTransdate(String transdate) {
    this.transdate = transdate;
  }

  public String getTranstime() {
    return transtime;
  }

  public void setTranstime(String transtime) {
    this.transtime = transtime;
  }

  public Integer getTranscode() {
    return transcode;
  }

  public void setTranscode(Integer transcode) {
    this.transcode = transcode;
  }

  public String getSourceType() {
    return sourceType;
  }

  public void setSourceType(String sourceType) {
    this.sourceType = sourceType;
  }

  public String getPayInfo() {
    return payInfo;
  }

  public void setPayInfo(String payInfo) {
    this.payInfo = payInfo;
  }

  public String getTradeflag() {
    return tradeflag;
  }

  public void setTradeflag(String tradeflag) {
    this.tradeflag = tradeflag;
  }

  public String getTransdesc() {
    return transdesc;
  }

  public void setTransdesc(String transdesc) {
    this.transdesc = transdesc;
  }

  public String getReverseFlag() {
    return reverseFlag;
  }

  public void setReverseFlag(String reverseFlag) {
    this.reverseFlag = reverseFlag;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getOppositeAccNo() {
    return oppositeAccNo;
  }

  public void setOppositeAccNo(String oppositeAccNo) {
    this.oppositeAccNo = oppositeAccNo;
  }

  public String getOppositeAccName() {
    return oppositeAccName;
  }

  public void setOppositeAccName(String oppositeAccName) {
    this.oppositeAccName = oppositeAccName;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Boolean getUpdateBala() {
    return updateBala;
  }

  public void setUpdateBala(Boolean updateBala) {
    this.updateBala = updateBala;
  }

  public String getTenantid() {
    return tenantid;
  }

  public void setTenantid(String tenantid) {
    this.tenantid = tenantid;
  }
}
