package com.supwisdom.dlpay.api.domain;

import com.supwisdom.dlpay.framework.domain.DictionaryTable;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Created by shuwei on 2019/4/9.
 */
@Entity
@Table(name = "TB_SOURCETYPE",
    indexes = {@Index(name = "sourcetype_idx", columnList = "sourcetype, tenantid", unique = true)})
public class TSourceType implements DictionaryTable, Serializable {
  private static final long serialVersionUID = 2424711106241326859L;

  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "sourcetype_id", length = 32)
  private String sourceTypeId;

  @Column(name = "SOURCETYPE", nullable = false, length = 20)
  private String sourceType;

  @Column(name = "ENABLE", length = 20)
  @NotNull
  private Boolean enable;

  @Column(name = "CHARGE_ENABLE", length = 10)
  @NotNull
  private Boolean chargeEnable; //充值总开关

  @Column(name = "CONSUME_ENABLE", length = 10)
  @NotNull
  private Boolean consumeEnable; //消费总开关

  @Column(name = "ANONYMOUS_ENABLE", length = 10)
  @NotNull
  private Boolean anonymousEnable; //匿名消费总开关

  @Column(name = "reversable")
  @NotNull
  private Boolean reversable;

  @Column(name = "checkable")
  @NotNull
  private Boolean checkable; // 是否需要清算

  @Column(name = "pay_subjno", length = 12)
  private @NotNull String paySubjno;

  @Column(name = "deposite_subjno", length = 12)
  private String depositeSubjno;

  @Column(name = "PAYDESC", length = 200)
  private String paydesc;

  @Column(name = "tplusn", nullable = false, precision = 5)
  private Integer tplusN; // 系统结算日期,  T+0 ~ T+N

  @Column(name = "START_CHKTIME", precision = 5)
  private String startChktime; //开始能对账的时间。比如微信、支付宝是上午10点生成对账单，一般设为10:30开始对，则填：103000；为空时这说明无限制

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantid = "";

  public String getSourceType() {
    return sourceType;
  }

  public void setSourceType(String sourceType) {
    this.sourceType = sourceType;
  }

  public Boolean getEnable() {
    return enable;
  }

  public void setEnable(Boolean enable) {
    this.enable = enable;
  }

  public Boolean getChargeEnable() {
    return chargeEnable;
  }

  public void setChargeEnable(Boolean chargeEnable) {
    this.chargeEnable = chargeEnable;
  }

  public Boolean getConsumeEnable() {
    return consumeEnable;
  }

  public void setConsumeEnable(Boolean consumeEnable) {
    this.consumeEnable = consumeEnable;
  }

  public Boolean getAnonymousEnable() {
    return anonymousEnable;
  }

  public void setAnonymousEnable(Boolean anonymousEnable) {
    this.anonymousEnable = anonymousEnable;
  }

  public String getPaydesc() {
    return paydesc;
  }

  public void setPaydesc(String paydesc) {
    this.paydesc = paydesc;
  }

  public Boolean getCheckable() {
    return checkable;
  }

  public void setCheckable(Boolean checkable) {
    this.checkable = checkable;
  }

  public Boolean getReversable() {
    return reversable;
  }

  public void setReversable(Boolean reversable) {
    this.reversable = reversable;
  }

  public String getTenantid() {
    return tenantid;
  }

  public void setTenantid(String tenantid) {
    this.tenantid = tenantid;
  }

  @Override
  public String getDictKey() {
    return this.sourceType;
  }

  @Override
  public Object getDictValue() {
    return this.paydesc;
  }

  public String getSourceTypeId() {
    return sourceTypeId;
  }

  public void setSourceTypeId(String sourceTypeId) {
    this.sourceTypeId = sourceTypeId;
  }

  public @NotNull String getPaySubjno() {
    return paySubjno;
  }

  public void setPaySubjno(@NotNull String paySubjno) {
    this.paySubjno = paySubjno;
  }

  public String getDepositeSubjno() {
    return depositeSubjno;
  }

  public void setDepositeSubjno(String depositeSubjno) {
    this.depositeSubjno = depositeSubjno;
  }

  public Integer getTplusN() {
    return tplusN;
  }

  public void setTplusN(Integer tplusN) {
    this.tplusN = tplusN;
  }

  public String getStartChktime() {
    return startChktime;
  }

  public void setStartChktime(String startChktime) {
    this.startChktime = startChktime;
  }
}
