package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.sql.Timestamp;

@Entity
@Table(name = "tb_sourcetype_check",
    indexes = {@Index(name = "sourcetype_check_idx", columnList = "sourcetype, tenantid", unique = true)})
public class TSourceTypeCheckStatus {
  @Id
  @SequenceGenerator(name = "st_checker_id", sequenceName = "SEQ_SOURCETYPE_CHECK", allocationSize = 1)
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "st_checker_id")
  @Column(name = "ID", nullable = false, length = 9)
  private Integer id;

  @Column(name = "sourcetype", length = 30)
  @NotNull
  private String sourceType;

  @Column(name = "start_accdate", length = 8)
  @NotNull
  private String startAccdate; // 对账起始日期

  @Column(name = "check_accdate", length = 8)
  @NotNull
  private String checkAccdate; // 当前对账记账日期

  @Column(name = "check_file_status")
  private Boolean checkFileOk; // 当前对账文件下载成功标志

  @Column(name = "check_status")
  @NotNull
  private Boolean checkStatus; // 当前对账完成状态

  @Column(name = "repair_status")
  private Boolean repairStatus; // 补帐完成状态

  @Column(name = "settle_status")
  @NotNull
  private Boolean settleStatus; // 是否可以结算

  @Column(name = "force_recheck")
  @NotNull
  private Boolean forceRecheck; // 是否对当前日期强制对账

  @Column(name = "last_update")
  @NotNull
  @Version
  private Timestamp lastUpdate;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantId;

  @Column(name = "chkfile_url", length = 400)
  private String chkfileUrl;

  @Column(name = "remark", length = 600)
  private String remark;

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public String getSourceType() {
    return sourceType;
  }

  public void setSourceType(String sourceType) {
    this.sourceType = sourceType;
  }

  public String getCheckAccdate() {
    return checkAccdate;
  }

  public void setCheckAccdate(String checkAccdate) {
    this.checkAccdate = checkAccdate;
  }

  public Boolean getForceRecheck() {
    return forceRecheck;
  }

  public void setForceRecheck(Boolean forceRecheck) {
    this.forceRecheck = forceRecheck;
  }

  public Timestamp getLastUpdate() {
    return lastUpdate;
  }

  public void setLastUpdate(Timestamp lastUpdate) {
    this.lastUpdate = lastUpdate;
  }

  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public String getStartAccdate() {
    return startAccdate;
  }

  public void setStartAccdate(String startAccdate) {
    this.startAccdate = startAccdate;
  }

  public Boolean getCheckFileOk() {
    return checkFileOk;
  }

  public void setCheckFileOk(Boolean checkFileOk) {
    this.checkFileOk = checkFileOk;
  }

  public Boolean getCheckStatus() {
    return checkStatus;
  }

  public void setCheckStatus(Boolean checkStatus) {
    this.checkStatus = checkStatus;
  }

  public String getChkfileUrl() {
    return chkfileUrl;
  }

  public void setChkfileUrl(String chkfileUrl) {
    this.chkfileUrl = chkfileUrl;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Boolean getSettleStatus() {
    return settleStatus;
  }

  public void setSettleStatus(Boolean settleStatus) {
    this.settleStatus = settleStatus;
  }

  public Boolean getRepairStatus() {
    return repairStatus;
  }

  public void setRepairStatus(Boolean repairStatus) {
    this.repairStatus = repairStatus;
  }

}
