package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Created by shuwei on 2019/4/9.
 */
@Entity
@Table(name = "TB_SOURCETYPE_CONFIG",
    indexes = {@Index(name = "source_type_config_idx", columnList = "sourcetype, configid, tenantid", unique = true)})
public class TSourceTypeConfig implements Serializable {
  private static final long serialVersionUID = 9020235338229267313L;
  @Id
  @SequenceGenerator(name = "sourcetype_cfg_id", sequenceName = "SEQ_SOURCETYPE_CONFIG", allocationSize = 1, initialValue = 1000)
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "sourcetype_cfg_id")
  @Column(name = "id", length = 32)
  private String id;

  @Column(name = "SOURCETYPE", length = 20)
  @NotNull
  private String sourceType;

  @Column(name = "CONFIGID", length = 40)
  @NotNull
  private String configid;

  @Column(name = "CONFIG_VALUE", length = 2000)
  private String configValue;

  @Column(name = "CONFIG_NAME", length = 200)
  private String configName;

  @Column(name = "GLOBALFLAG")
  private Boolean globalflag = false;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantid = "";

  public String getSourceType() {
    return sourceType;
  }

  public void setSourceType(String sourceType) {
    this.sourceType = sourceType;
  }

  public String getConfigid() {
    return configid;
  }

  public void setConfigid(String configid) {
    this.configid = configid;
  }

  public String getConfigValue() {
    return configValue;
  }

  public void setConfigValue(String configValue) {
    this.configValue = configValue;
  }

  public String getConfigName() {
    return configName;
  }

  public void setConfigName(String configName) {
    this.configName = configName;
  }

  public String getTenantid() {
    return tenantid;
  }

  public void setTenantid(String tenantid) {
    this.tenantid = tenantid;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Boolean getGlobalflag() {
    return globalflag;
  }

  public void setGlobalflag(Boolean globalflag) {
    this.globalflag = globalflag;
  }
}
