package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;
import javax.validation.constraints.NotNull;

@Entity
@Table(name = "TB_SUBJECTDTL",
    indexes = {@Index(name = "subjdtl_accdate", columnList = "accdate"),
        @Index(name = "subjdtl_subjno", columnList = "subjno")})
public class TSubjectdtl {
  @Id
  @Column(name = "refno", length = 32, nullable = false)
  private String refno;

  @Column(name = "accdate", length = 8)
  @NotNull
  private String accdate;

  @Column(name = "subjno", length = 10)
  @NotNull
  private String subjectno;

  @Column(name = "subjname", length = 200)
  private String subjectName;

  @Column(name = "amount", scale = 2, precision = 15)
  @NotNull
  private Double amount;

  @Column(name = "tradecode", precision = 8)
  @NotNull
  private Integer tradeCode;

  @Column(name = "transdate", length = 8)
  @NotNull
  private String transDate;

  @Column(name = "transtime", length = 6)
  @NotNull
  private String transTime;

  @Column(name = "paytype", length = 20)
  private String payType;

  @Column(name = "payinfo", length = 200)
  private String payInfo;

  @Column(name = "OPPOSITEACCNO", length = 20)
  private String oppositeAccNo;

  @Column(name = "OPPOSITEACCNAME", length = 200)
  private String oppositeAccName;

  @Column(name = "status", length = 20)
  @NotNull
  private String status;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantid = "";

  @Column(name = "DTLTYPE", length = 20)
  @NotNull
  private String dtltype;

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }

  public String getSubjectno() {
    return subjectno;
  }

  public void setSubjectno(String subjectno) {
    this.subjectno = subjectno;
  }

  public String getSubjectName() {
    return subjectName;
  }

  public void setSubjectName(String subjectName) {
    this.subjectName = subjectName;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public String getTransDate() {
    return transDate;
  }

  public void setTransDate(String transDate) {
    this.transDate = transDate;
  }

  public String getTransTime() {
    return transTime;
  }

  public void setTransTime(String transTime) {
    this.transTime = transTime;
  }

  public String getPayType() {
    return payType;
  }

  public void setPayType(String payType) {
    this.payType = payType;
  }

  public String getPayInfo() {
    return payInfo;
  }

  public void setPayInfo(String payInfo) {
    this.payInfo = payInfo;
  }

  public String getOppositeAccNo() {
    return oppositeAccNo;
  }

  public void setOppositeAccNo(String oppositeAccNo) {
    this.oppositeAccNo = oppositeAccNo;
  }

  public String getOppositeAccName() {
    return oppositeAccName;
  }

  public void setOppositeAccName(String oppositeAccName) {
    this.oppositeAccName = oppositeAccName;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Integer getTradeCode() {
    return tradeCode;
  }

  public void setTradeCode(Integer tradeCode) {
    this.tradeCode = tradeCode;
  }

  public String getTenantid() {
    return tenantid;
  }

  public void setTenantid(String tenantid) {
    this.tenantid = tenantid;
  }

  public String getDtltype() {
    return dtltype;
  }

  public void setDtltype(String dtltype) {
    this.dtltype = dtltype;
  }
}
