package com.supwisdom.dlpay.api.domain;

import com.supwisdom.dlpay.framework.util.Subject;
import com.supwisdom.dlpay.framework.util.TradeDict;

import javax.persistence.*;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import java.sql.Timestamp;
import java.util.List;

import static javax.persistence.FetchType.LAZY;

@Entity
@Table(name = "TB_TRANSACTIONMAIN",
    indexes = {@Index(name = "transmain_accdate", columnList = "accdate"),
        @Index(name = "transmain_status", columnList = "status"),
        @Index(name = "transmain_tenantid_idx", columnList = "tenantid"),
        @Index(name = "transmain_outtrade", unique = true, columnList = "outid, outtradeno")})
@SequenceGenerator(name = "seq_refno", allocationSize = 100)
public class TTransactionMain {
  @Id
  @Column(name = "refno", nullable = false, length = 32)
  private String refno;

  @Column(name = "accdate", length = 8)
  @NotNull
  @Digits(integer = 8, fraction = 0)
  private String accdate;

  @Column(name = "checkable")
  @NotNull
  private Boolean checkable; // 是否需要清算的交易

  @Column(name = "checkdate", length = 8)
  private String checkDate;

  @Column(name = "transcode")
  @NotNull
  private Integer transCode;

  @Column(name = "person")
  @NotNull
  private Boolean person = false;

  @Column(name = "shop")
  @NotNull
  private Boolean shop = false;

  @Column(name = "subject")
  @NotNull
  private Boolean subject = false;

  @Column(name = "status", length = 20)
  @NotNull
  private String status = TradeDict.DTL_STATUS_NONE;

  @Column(name = "sourcetype", length = 20)
  private String sourceType = "";

  @Column(name = "SOURCETYPE_REFNO", length = 32)
  private String sourceTypeRefno;

  @Column(name = "outtradeno", length = 60)
  private String outTradeNo = "";

  @Column(name = "outid", length = 60)
  private String outId;

  @Column(name = "OPERID", precision = 9)
  private String operid; //操作员ID

  @Column(name = "OPERTYPE", length = 10)
  private String opertype; // person - 个人， shop - 商户， operator - 操作员

  @Column(name = "settledate", length = 8)
  private String settleDate;

  @Column(name = "create_time")
  @NotNull
  private Timestamp createTime;

  @Column(name = "end_time")
  private Timestamp endTime;

  @Column(name = "update_time")
  @Version
  private Timestamp updateTime;

  @Column(name = "reverse_type", nullable = false, length = 10)
  @NotNull
  private String reverseType = TradeDict.REVERSE_FLAG_NONE; // 流水标识， none - 正常交易流水， cancel - 撤销流水， refund - 退款流水

  // 撤销、退款原流水参考号
  @Column(name = "reverse_refno")
  private String reverseRefno = "";

  @Column(name = "reverse_flag", nullable = false, length = 10)
  @NotNull
  private String reverseFlag = TradeDict.REVERSE_FLAG_NONE; // 冲正标识， none - 未冲正, refund - 被退款, cancel - 被冲正

  @Column(name = "refund_amount", nullable = false)
  private Double refundAmount = 0.0;

  @OneToOne(targetEntity = TPersondtl.class, fetch = LAZY, cascade = CascadeType.ALL)
  @JoinColumn(name = "refno", referencedColumnName = "refno")
  private TPersondtl personDtl;

  @OneToOne(targetEntity = TShopdtl.class, fetch = LAZY, cascade = CascadeType.ALL)
  @JoinColumn(name = "refno", referencedColumnName = "refno")
  private TShopdtl shopDtl;

  @OneToOne(targetEntity = TSubjectdtl.class, fetch = LAZY, cascade = CascadeType.ALL)
  @JoinColumn(name = "refno", referencedColumnName = "refno")
  private TSubjectdtl subjectDtl;

  @OneToMany(targetEntity = TDebitCreditDtl.class, fetch = LAZY, cascade = CascadeType.ALL)
  @JoinColumn(name = "refno", referencedColumnName = "refno")
  private List<TDebitCreditDtl> details;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantid = "";

  @Column(name = "DTLTYPE", length = 20)
  @NotNull
  private String dtltype;

  public String getDtltype() {
    return dtltype;
  }

  public void setDtltype(String dtltype) {
    this.dtltype = dtltype;
  }

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }


  public Boolean getPerson() {
    return person;
  }

  public void setPerson(Boolean person) {
    this.person = person;
  }

  public Boolean getShop() {
    return shop;
  }

  public void setShop(Boolean shop) {
    this.shop = shop;
  }

  public Boolean getSubject() {
    return subject;
  }

  public void setSubject(Boolean subject) {
    this.subject = subject;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getOutTradeNo() {
    return outTradeNo;
  }

  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  public String getOutId() {
    return outId;
  }

  public void setOutId(String outId) {
    this.outId = outId;
  }

  public String getReverseFlag() {
    return reverseFlag;
  }

  public void setReverseFlag(String reverseFlag) {
    this.reverseFlag = reverseFlag;
  }

  public TPersondtl getPersonDtl() {
    return personDtl;
  }

  public TShopdtl getShopDtl() {
    return shopDtl;
  }

  public TSubjectdtl getSubjectDtl() {
    return subjectDtl;
  }

  public List<TDebitCreditDtl> getDetails() {
    return details;
  }

  public void setPersonDtl(TPersondtl personDtl) {
    this.personDtl = personDtl;
  }

  public void setShopDtl(TShopdtl shopDtl) {
    this.shopDtl = shopDtl;
  }

  public void setSubjectDtl(TSubjectdtl subjectDtl) {
    this.subjectDtl = subjectDtl;
  }

  public void setDetails(List<TDebitCreditDtl> details) {
    this.details = details;
  }

  public Timestamp getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Timestamp createTime) {
    this.createTime = createTime;
  }

  public Timestamp getEndTime() {
    return endTime;
  }

  public void setEndTime(Timestamp endTime) {
    this.endTime = endTime;
  }

  public String getOperid() {
    return operid;
  }

  public void setOperid(String operid) {
    this.operid = operid;
  }

  public String getOpertype() {
    return opertype;
  }

  public void setOpertype(String opertype) {
    this.opertype = opertype;
  }

  public String getCheckDate() {
    return checkDate;
  }

  public void setCheckDate(String checkDate) {
    this.checkDate = checkDate;
  }

  public Boolean getCheckable() {
    return checkable;
  }

  public void setCheckable(Boolean checkable) {
    this.checkable = checkable;
  }

  public String getSettleDate() {
    return settleDate;
  }

  public void setSettleDate(String settleDate) {
    this.settleDate = settleDate;
  }

  public String getSourceType() {
    return sourceType;
  }

  public void setSourceType(String sourceType) {
    this.sourceType = sourceType;
  }

  public String getSourceTypeRefno() {
    return sourceTypeRefno;
  }

  public void setSourceTypeRefno(String sourceTypeRefno) {
    this.sourceTypeRefno = sourceTypeRefno;
  }

  public Integer getTransCode() {
    return transCode;
  }

  public void setTransCode(Integer transCode) {
    this.transCode = transCode;
  }

  public String getReverseType() {
    return reverseType;
  }

  public void setReverseType(String reverseType) {
    this.reverseType = reverseType;
  }

  public String getReverseRefno() {
    return reverseRefno;
  }

  public void setReverseRefno(String reverseRefno) {
    this.reverseRefno = reverseRefno;
  }

  public Double getRefundAmount() {
    return refundAmount;
  }

  public void setRefundAmount(Double refundAmount) {
    this.refundAmount = refundAmount;
  }

  public Double sumAmountByAccno(String accno, String subjno,
                                 String debitOrCredit) {
    Double debitSum = 0.0;
    Double creditSum = 0.0;
    for (TDebitCreditDtl dtl : getDetails()) {
      if (dtl.getDraccno().equals(accno) && dtl.getDrsubjno().equals(subjno)) {
        debitSum += dtl.getAmount();
      }
      if (dtl.getCraccno().equals(accno) && dtl.getCrsubjno().equals(subjno)) {
        creditSum += dtl.getAmount();
      }
    }
    if (Subject.SUBJNO_MACHANT_INCOME.equals(subjno)
        || Subject.SUBJNO_PERSONAL_DEPOSIT.equals(subjno)) {
      if ("debit".equals(debitOrCredit)) {
        return -debitSum;
      } else if ("credit".equals(debitOrCredit)) {
        return creditSum;
      } else {
        return creditSum - debitSum;
      }
    } else if (subjno.startsWith("1")) {
      if ("debit".equals(debitOrCredit)) {
        return debitSum;
      } else if ("credit".equals(debitOrCredit)) {
        return -creditSum;
      } else {
        return debitSum - creditSum;
      }
    }
    return 0.0;
  }

  public String getTenantid() {
    return tenantid;
  }

  public void setTenantid(String tenantid) {
    this.tenantid = tenantid;
  }

  public Timestamp getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Timestamp updateTime) {
    this.updateTime = updateTime;
  }
}
