package com.supwisdom.dlpay.api.service;

import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

/**
 * Created by shuwei on 2019/4/9.
 */
public interface SourceTypeService {

  /**
   * 获取支付能力充值参数全局配置
   */
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  Map<String, String> getChargePaytypeConfig(String paytype, boolean ignoreStatus) throws Exception;

  /**
   * 获取商户支付能力消费参数配置
   */
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  Map<String, String> getConsumePaytypeConfig(String paytype, String shopaccno, boolean anonymousflag, boolean ignoreStatus) throws Exception;

}
