package com.supwisdom.dlpay.api.service.impl;

import com.supwisdom.dlpay.api.dao.*;
import com.supwisdom.dlpay.api.domain.*;
import com.supwisdom.dlpay.api.service.SourceTypeService;
import com.supwisdom.dlpay.exception.TransactionProcessException;
import com.supwisdom.dlpay.framework.tenant.TenantContext;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.TradeErrorCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by shuwei on 2019/4/9.
 */
@Service
public class SourceTypeServiceImpl implements SourceTypeService {
  private final SourceTypeDao sourceTypeDao;
  private final SourceTypeConfigDao sourceTypeConfigDao;
  private final ShopSourceTypeDao shopSourceTypeDao;
  private final ShopSourceTypeConfigDao shopSourceTypeConfigDao;
  private final SourceTypeCheckDao sourceTypeCheckDao;

  @Autowired
  public SourceTypeServiceImpl(SourceTypeDao sourceTypeDao, SourceTypeConfigDao sourceTypeConfigDao,
                               ShopSourceTypeDao shopSourceTypeDao, ShopSourceTypeConfigDao shopSourceTypeConfigDao, SourceTypeCheckDao sourceTypeCheckDao) {
    this.sourceTypeDao = sourceTypeDao;
    this.sourceTypeConfigDao = sourceTypeConfigDao;
    this.shopSourceTypeDao = shopSourceTypeDao;
    this.shopSourceTypeConfigDao = shopSourceTypeConfigDao;
    this.sourceTypeCheckDao = sourceTypeCheckDao;
  }


  @Override
  public Map<String, String> getChargePaytypeConfig(String paytype, boolean ignoreStatus) throws Exception {
    TSourceType tSourceType = sourceTypeDao.getBySourceType(paytype);
    if (null == tSourceType) {
      throw new TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统不支持支付方式[" + paytype + "]");
    } else if (!ignoreStatus && (!tSourceType.getEnable() || !tSourceType.getChargeEnable())) {
      throw new TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统充值未启用支付方式[" + paytype + "]");
    }

    Map<String, String> result = new HashMap<>(0);
    List<TSourceTypeConfig> list = sourceTypeConfigDao.getBySourceType(paytype);
    if (!StringUtil.isEmpty(list)) {
      for (TSourceTypeConfig config : list) {
        result.put(config.getConfigid(), config.getConfigValue());
      }
    }
    return result;
  }

  @Override
  public Map<String, String> getConsumePaytypeConfig(String paytype, String shopaccno, boolean anonymousflag, boolean ignoreStatus) throws Exception {
    //step1: 判断系统支付能力是否启用
    TSourceType tSourceType = sourceTypeDao.getBySourceType(paytype);
    if (null == tSourceType) {
      throw new TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统不支持支付方式[" + paytype + "]");
    } else {
      if (!ignoreStatus && (!tSourceType.getEnable() || !tSourceType.getConsumeEnable())) {
        throw new TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统未启用支付方式[" + paytype + "]消费");
      }
      if (!ignoreStatus && anonymousflag && !tSourceType.getAnonymousEnable()) {
        throw new TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统支付方式[" + paytype + "]未启用匿名消费");
      }
    }

    //step2: 判断商户支付能力是否启用
    TShopSourceType tShopSourceType = shopSourceTypeDao.getById(paytype, shopaccno);
    if (null == tShopSourceType) {
      throw new TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[" + shopaccno + "]未启用支付方式[" + paytype + "]");
    } else {
      if (!ignoreStatus && !tShopSourceType.getConsumeEnable()) {
        throw new TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[" + shopaccno + "]未启用支付方式[" + paytype + "]消费");
      }
      if (!ignoreStatus && anonymousflag && !tShopSourceType.getAnonymousEnable()) {
        throw new TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[" + shopaccno + "]的支付方式[" + paytype + "]未启用匿名消费");
      }
    }

    Map<String, String> result = new HashMap<>(0);
    List<TSourceTypeConfig> list = sourceTypeConfigDao.getBySourceType(paytype);
    if (!StringUtil.isEmpty(list)) {
      for (TSourceTypeConfig config : list) {
        if (config.getGlobalflag()) {
          result.put(config.getConfigid(), config.getConfigValue()); //统用参数
        }
      }
    }

    List<TShopSourceTypeConfig> shoplist = shopSourceTypeConfigDao.getShopSourceTypeConfigs(paytype, shopaccno);
    if (!StringUtil.isEmpty(shoplist)) {
      for (TShopSourceTypeConfig shopconfig : shoplist) {
        result.put(shopconfig.getConfigid(), shopconfig.getConfigValue()); //个性参数
      }
    }

    return result;
  }
}
