package com.supwisdom.dlpay.api.types;

public enum IDTypes {
  IDCARD(52, "idcard"), // 身份证
  RESIDENCE_BOOKLET(55, "residence_booklet"), //户口簿
  PASSPORT(70, "passport"), // 护照
  HK_MACAU_PASS(76, "hk_macau_pass"), // 港澳居民来往内地通行证
  TAIWAN_PASS(67, "taiwan_pass"), // 台湾同胞来往内地通行证
  FOREIGNER_RESIDENCE_PERMIT(68, "foreigner_residence_permit"), // 外国人居留证
  MILITARY_IDCARD(58, "military_idcard"), //  军官证
  SOLDIER_IDCARD(64, "soldier_idcard"), //  士兵证
  DRIVING_LICENSE(-97, "driving_license"), // 驾照
  STUDENT_IDCARD(-98, "student_idcard"), // 学生证
  OTHERS(-99, "unknown"),
  IDTYPE_LIST(-100, new IDTypes[]{IDCARD, RESIDENCE_BOOKLET, PASSPORT, HK_MACAU_PASS, TAIWAN_PASS, FOREIGNER_RESIDENCE_PERMIT, MILITARY_IDCARD, SOLDIER_IDCARD,
      DRIVING_LICENSE, STUDENT_IDCARD, OTHERS}); // 其它


  IDTypes(int id, Object data) {
    this.id = id;
    this.data = data;
  }

  public String value() {
    return this.data.toString();
  }

  public int getId() {
    return this.id;
  }

  public Object getData() {
    return this.data;
  }


  private Object data;

  private int id;

  public static String findById(int id) {
    IDTypes[] list = (IDTypes[]) IDTypes.IDTYPE_LIST.getData();
    for (IDTypes item : list) {
      if (item.getId() == id) {
        return item.value();
      }
    }
    return null;
  }

  public static int findByValue(String idtype) {
    IDTypes[] list = (IDTypes[]) IDTypes.IDTYPE_LIST.getData();
    for (IDTypes item : list) {
      if (item.value().equals(idtype)) {
        return item.getId();
      }
    }
    return -999;
  }

  @Override
  public String toString() {
    return value();
  }
}
