package com.supwisdom.dlpay.api.util;

import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public class HMACUtil {
  public static String sha256HMAC(String message, String secret) {
    byte[] bytes = HmacUtils.getInitializedMac(HmacAlgorithms.HMAC_SHA_256, secret.getBytes())
        .doFinal(message.getBytes());
    return Hex.encodeHexString(bytes, true);
  }

  private static String byteArrayToHexString(byte[] bytes) {
    return Hex.encodeHexString(bytes, true);
  }
}
