package com.supwisdom.dlpay.api.validator;

import com.supwisdom.dlpay.api.annotation.IDNoCheck;
import com.supwisdom.dlpay.api.types.IDTypes;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class IDNoCheckValidator implements ConstraintValidator<IDNoCheck, Object> {
  private String idnoField;
  private String idtypeField;
  private String[] idtypeList;

  @Override
  public boolean isValid(Object value, ConstraintValidatorContext context) {
    try {
      String idtype = BeanUtils.getProperty(value, idtypeField);
      if (idtype == null) {
        return true;
      }
      if (!Arrays.asList(idtypeList).contains(idtype)) {
        return false;
      }
      String idno = BeanUtils.getProperty(value, idnoField);
      if (StringUtils.isEmpty(idno)) {
        return false;
      }
      if (IDTypes.IDCARD.value().equals(idtype) && idno.length() != 18) {
        return false;
      }
      return true;
    } catch (IllegalAccessException e) {
      e.printStackTrace();
    } catch (InvocationTargetException e) {
      e.printStackTrace();
    } catch (NoSuchMethodException e) {
      e.printStackTrace();
    }
    return false;
  }

  @Override
  public void initialize(IDNoCheck constraintAnnotation) {
    idnoField = constraintAnnotation.idno();
    idtypeField = constraintAnnotation.idtype();
    if (StringUtils.isEmpty(idnoField) || StringUtils.isEmpty(idtypeField)) {
      throw new IllegalArgumentException("IDNO 和 IDType 字段必须指定");
    }
    Object value = constraintAnnotation.value().getData();
    if (value instanceof IDTypes[]) {
      idtypeList = new String[((IDTypes[]) value).length];
      for (int i = 0; i < ((IDTypes[]) value).length; ++i) {
        idtypeList[i] = ((IDTypes[]) value)[i].value();
      }
    } else if (value instanceof String) {
      idtypeList = new String[]{(String) value};
    } else {
      throw new IllegalArgumentException("IDTypes 类型错误");
    }
  }
}
