package com.supwisdom.dlpay.api.validator;

import com.supwisdom.dlpay.api.annotation.MobileNumber;
import com.supwisdom.dlpay.api.util.MobileNumberCheck;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class MobileNumberValidator implements ConstraintValidator<MobileNumber, String> {

  @Override
  public boolean isValid(String value, ConstraintValidatorContext context) {
    if (value == null || StringUtils.isEmpty(value)) {
      return true;
    }
    return MobileNumberCheck.isPhone(value);
  }

  @Override
  public void initialize(MobileNumber constraintAnnotation) {
  }
}
