package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TDictionary;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface DictionaryDao extends JpaRepository<TDictionary, Integer> {
  @Query("from TDictionary t where t.dicttype=?1 order by t.dictid ")
  List<TDictionary> findAllByDicttype(String dicttype);

  void deleteByDicttype(String dicttype);

  @Query("from TDictionary t where t.dicttype=?1 and t.dictval=?2 ")
  TDictionary getByDicttypeAndDictval(String dicttype, String dictval);
}
