package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.domain.TTaskLock;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface TaskLockDao extends JpaRepository<TTaskLock, String> {

  //================= database=Oracle =================//
  @Query(value = "select  to_char(sysdate,'yyyymmdd') as hostdate,to_char(sysdate,'hh24miss') as hosttime,to_char(sysdate,'yyyymmddhh24miss') as hostdatetime, sysdate from dual", nativeQuery = true)
  SystemDateTime getOracleDatetime();

  @Query(value = "select  to_char(CURRENT_TIMESTAMP,'yyyymmdd') as hostdate," + "" +
      "to_char(CURRENT_TIMESTAMP,'hh24miss') as hosttime,to_char(CURRENT_TIMESTAMP,'yyyymmddhh24miss') as hostdatetime," +
      " CURRENT_TIMESTAMP as sysdate", nativeQuery = true)
  SystemDateTime getPGDatetime();

  @Query(value = " select to_char(sysdate,'yyyyMMddhh24miss')||to_char(SEQ_REFNO.nextval,'FM000000') as billno from dual ", nativeQuery = true)
  String getOracleRefno();

  //================= database=PG =================//
  @Query(value = " select to_char(CURRENT_TIMESTAMP,'yyyyMMddhh24miss')||to_char(nextval('SEQ_REFNO'),'FM000000') as billno ", nativeQuery = true)
  String getPgRefno();
}
