package com.supwisdom.dlpay.framework.domain;

import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

import javax.persistence.*;
import javax.validation.constraints.NotNull;

@Entity
@Table(name = "TB_APICLIENT",
    indexes = {@Index(name = "apiclient_idx", columnList = "appid, tenantid", unique = true)})
public class TApiClient {
  @Id
  @SequenceGenerator(name = "apiclient_id", sequenceName = "SEQ_APICLIENT", allocationSize = 1, initialValue = 10)
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "apiclient_id")
  @Column(name = "id")
  @NotNull
  private Integer id;

  @Column(name = "appid", length = 20)
  @NotNull
  private String appid;

  @Column(name = "secret", length = 64)
  @NotNull
  private String secret;

  @Column(name = "status", length = 10)
  @NotNull
  private String status;

  @Column(name = "roles", length = 300)
  private String roles;

  @Column(name = "BCRYPT_SECRET", length = 64)
  @NotNull
  private String bcryptSecret;

  @Column(name = "THIRDURL", length = 200)
  private String thirdurl;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantId;


  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getSecret() {
    return secret;
  }

  public void setSecret(String secret) {
    this.secret = secret;
    this.bcryptSecret = new BCryptPasswordEncoder().encode(secret);
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getRoles() {
    return roles;
  }

  public void setRoles(String roles) {
    this.roles = roles;
  }

  public String getBcryptSecret() {
    return bcryptSecret;
  }

  public String getThirdurl() {
    return thirdurl;
  }

  public void setThirdurl(String thirdurl) {
    this.thirdurl = thirdurl;
  }

  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }
}
