package com.supwisdom.dlpay.framework.domain;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Entity
@Table(name = "TB_DICTIONARY",
    indexes = {@Index(name = "dictionary_idx", columnList = "dicttype, dictval, tenantid", unique = true)})
public class TDictionary implements DictionaryTable, Serializable {
  private static final long serialVersionUID = -4346024672769882893L;
  @Id
  @Column(name = "id")
  @SequenceGenerator(name = "dictid", sequenceName = "SEQ_DICTIONARY", allocationSize = 1, initialValue = 1000)
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "dictid")
  @NotNull
  private Integer dictid;

  @Column(name = "DICTTYPE")
  @NotNull
  private String dicttype;

  @Column(name = "DICTVAL", length = 30)
  @NotNull
  private String dictval;

  @Column(name = "DICTTYPENAME", length = 60)
  private String dicttypename;

  @Column(name = "DICTCAPTION", length = 60)
  private String dictcaption;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantId;

  public String getDicttype() {
    return dicttype;
  }

  public void setDicttype(String dicttype) {
    this.dicttype = dicttype;
  }

  public String getDictval() {
    return dictval;
  }

  public void setDictval(String dictval) {
    this.dictval = dictval;
  }

  public String getDicttypename() {
    return dicttypename;
  }

  public void setDicttypename(String dicttypename) {
    this.dicttypename = dicttypename;
  }

  public String getDictcaption() {
    return dictcaption;
  }

  public void setDictcaption(String dictcaption) {
    this.dictcaption = dictcaption;
  }

  public Integer getDictid() {
    return dictid;
  }

  public void setDictid(Integer dictid) {
    this.dictid = dictid;
  }

  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public String getDictKey() {
    return this.dictval;
  }

  @Override
  public Object getDictValue() {
    return this.dictcaption;
  }
}
