package com.supwisdom.dlpay.framework.domain;

import com.supwisdom.dlpay.api.annotation.MobileNumber;
import com.supwisdom.dlpay.framework.util.TradeDict;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import javax.persistence.*;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Collection;

@Entity
@Table(name = "TB_OPERATOR",
    indexes = {@Index(name = "opercode_idx", columnList = "OPERCODE, tenantid", unique = true)})
public class TOperator implements UserDetails, Serializable {
  private static final long serialVersionUID = 2148742269021236587L;
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "OPERID", nullable = false, length = 32)
  private String operid;

  @Column(name = "OPERCODE", length = 20)
  @NotNull
  private String opercode;

  @Column(name = "OPERTYPE", length = 20)
  @NotNull
  private String opertype;

  @Column(name = "OPERNAME", length = 100)
  @NotNull
  private String opername;

  @Column(name = "OPERPWD", length = 80)
  @NotNull
  private String operpwd;

  @Column(name = "STATUS", length = 32)
  @NotNull
  private String status;

  @Column(name = "SEX", length = 10)
  private String sex;

  @Column(name = "MOBILE", length = 20)
  @MobileNumber(message = "请输入正确手机号")
  private String mobile;

  @Column(name = "EMAIL", length = 60)
  @Email(message = "请输入正确邮箱")
  private String email;

  @Column(name = "OPENDATE", length = 8)
  private String opendate;

  @Column(name = "CLOSEDATE", length = 8)
  private String closedate;

  @Column(name = "ROLEID", length = 32)
  private String roleid;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantId;

  @Column(name = "thirdadmin", length = 20)
  @NotNull
  private String thirdadmin;

  @Column(name = "jti", length = 64)
  private String jti;

  @Transient
  private Collection<? extends GrantedAuthority> authorities;  //权限

  public TOperator() {
  }

  public TOperator(String opercode, String opername) {
    this.opercode = opercode;
    this.opername = opername;
  }

  public TOperator(String opercode, String opertype, String opername, String operpwd, String status, String sex, String mobile, String email, String opendate, String closedate,String jti, Collection<? extends GrantedAuthority> authorities) {
    this.opercode = opercode;
    this.opertype = opertype;
    this.opername = opername;
    this.operpwd = operpwd;
    this.status = status;
    this.sex = sex;
    this.mobile = mobile;
    this.email = email;
    this.opendate = opendate;
    this.closedate = closedate;
    this.jti = jti;
    this.authorities = authorities;
  }

  public String getOperid() {
    return operid;
  }

  public void setOperid(String operid) {
    this.operid = operid;
  }

  public String getOpercode() {
    return opercode;
  }

  public void setOpercode(String opercode) {
    this.opercode = opercode;
  }

  public String getOpertype() {
    return opertype;
  }

  public void setOpertype(String opertype) {
    this.opertype = opertype;
  }

  public String getOpername() {
    return opername;
  }

  public void setOpername(String opername) {
    this.opername = opername;
  }

  public String getOperpwd() {
    return operpwd;
  }

  public void setOperpwd(String operpwd) {
    this.operpwd = operpwd;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getSex() {
    return sex;
  }

  public void setSex(String sex) {
    this.sex = sex;
  }

  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getOpendate() {
    return opendate;
  }

  public void setOpendate(String opendate) {
    this.opendate = opendate;
  }

  public String getClosedate() {
    return closedate;
  }

  public void setClosedate(String closedate) {
    this.closedate = closedate;
  }

  public String getJti() {
    return jti;
  }

  public void setJti(String jti) {
    this.jti = jti;
  }

  public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
    this.authorities = authorities;
  }

  @Override
  public Collection<? extends GrantedAuthority> getAuthorities() {
    return this.authorities;
  }

  @Override
  public String getPassword() {
    return this.operpwd;
  }

  @Override
  public String getUsername() {
    return this.opercode;
  }

  @Override
  public boolean isAccountNonExpired() {
    return true; //账户不会过期
  }

  @Override
  public boolean isAccountNonLocked() {
    return !TradeDict.STATUS_LOCKED.equals(this.status); //true - 没锁定
  }

  @Override
  public boolean isCredentialsNonExpired() {
    return true; //TODO:密码是否未过期
  }

  @Override
  public boolean isEnabled() {
    return !TradeDict.STATUS_CLOSED.equals(this.status);  //注销操作员不启用
  }

  public String getRoleid() {
    return roleid;
  }

  public void setRoleid(String roleid) {
    this.roleid = roleid;
  }

  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public String getThirdadmin() {
    return thirdadmin;
  }

  public void setThirdadmin(String thirdadmin) {
    this.thirdadmin = thirdadmin;
  }
}
