package com.supwisdom.dlpay.framework.domain;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Entity
@Table(name = "TB_SUBJECT",
    indexes = {@Index(name = "subject_idx", columnList = "subjno, tenantid", unique = true)})
public class TSubject implements Serializable, DictionaryTable {

  @Id
  @Column(name = "subjid")
  @NotNull
  @SequenceGenerator(name = "subjectid", sequenceName = "SEQ_SUBJECTID", allocationSize = 1, initialValue = 1000)
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "subjectid")
  private Integer id;

  @Column(name = "SUBJNO", nullable = false, length = 10)
  private String subjno;

  @Column(name = "SUBJNAME", length = 60)
  @NotNull
  private String subjname;

  @Column(name = "SUBJTYPE", precision = 1)
  private Integer subjtype;

  @Column(name = "BALFLAG", precision = 1)
  private Integer balflag;

  @Column(name = "FSUBJNO", length = 10)
  private String fsubjno;

  @Column(name = "SUBJLEVEL", precision = 1)
  private Integer subjlevel;

  @Column(name = "ENDFLAG", precision = 1)
  private Integer endflag;

  @Column(name = "OPENDATE", precision = 8)
  private Integer opendate;

  @Column(name = "DISPLAYFLAG", length = 1)
  private String displayflag;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantId;

  public String getSubjno() {
    return subjno;
  }

  public void setSubjno(String subjno) {
    this.subjno = subjno;
  }

  public String getSubjname() {
    return subjname;
  }

  public void setSubjname(String subjname) {
    this.subjname = subjname;
  }

  public Integer getSubjtype() {
    return subjtype;
  }

  public void setSubjtype(Integer subjtype) {
    this.subjtype = subjtype;
  }

  public Integer getBalflag() {
    return balflag;
  }

  public void setBalflag(Integer balflag) {
    this.balflag = balflag;
  }

  public String getFsubjno() {
    return fsubjno;
  }

  public void setFsubjno(String fsubjno) {
    this.fsubjno = fsubjno;
  }

  public Integer getSubjlevel() {
    return subjlevel;
  }

  public void setSubjlevel(Integer subjlevel) {
    this.subjlevel = subjlevel;
  }

  public Integer getEndflag() {
    return endflag;
  }

  public void setEndflag(Integer endflag) {
    this.endflag = endflag;
  }

  public Integer getOpendate() {
    return opendate;
  }

  public void setOpendate(Integer opendate) {
    this.opendate = opendate;
  }

  public String getDisplayflag() {
    return displayflag;
  }

  public void setDisplayflag(String displayflag) {
    this.displayflag = displayflag;
  }

  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  @Override
  public String getDictKey() {
    return this.subjno;
  }

  @Override
  public Object getDictValue() {
    return this.subjname;
  }
}
