package com.supwisdom.dlpay.framework.domain;

import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.NumberUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.SysparaUtil;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Entity
@Table(name = "TB_SYSPARA")
@IdClass(TSysparaPK.class)
public class TSyspara implements Serializable {
  private static final long serialVersionUID = 6760877848228345624L;
  @Id
  @Column(name = "PARAID", nullable = false, precision = 9)
  private Integer paraid;

  @Id
  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantId;

  @Column(name = "PARAVAL", length = 100)
  private String paraval;

  @Column(name = "PARANAME", length = 90)
  private String paraname;

  @Column(name = "PARAUNIT", length = 20)
  private String paraunit;

  @Column(name = "VALUETYPE", length = 10)
  private String valueType = SysparaUtil.VALUETYPE_STRING;

  @Column(name = "EDITFLAG", precision = 1)
  @NotNull
  private Integer editflag;

  @Column(name = "DISPLAYFLAG", length = 10)
  @NotNull
  private String displayflag;

  @Column(name = "REMARK", length = 240)
  private String remark;

  @Column(name = "LASTSAVED", length = 14)
  @NotNull
  private String lastsaved;


  public TSyspara() {
  }

  public TSyspara(Integer paraid, Integer editflag) {
    this.paraid = paraid;
    this.editflag = editflag;
  }

  public TSyspara(Integer paraid, String paraval, String paraname, String paraunit, String valueType, Integer editflag, String displayflag, String remark, String lastsaved) {
    this.paraid = paraid;
    this.paraval = paraval;
    this.paraname = paraname;
    this.paraunit = paraunit;
    this.valueType = valueType;
    this.editflag = editflag;
    this.displayflag = displayflag;
    this.remark = remark;
    this.lastsaved = lastsaved;
  }

  public Integer getParaid() {
    return paraid;
  }

  public void setParaid(Integer paraid) {
    this.paraid = paraid;
  }

  public String getParaval() {
    return paraval;
  }

  public void setParaval(String paraval) {
    this.paraval = paraval;
  }

  public String getParaname() {
    return paraname;
  }

  public void setParaname(String paraname) {
    this.paraname = paraname;
  }

  public String getParaunit() {
    return paraunit;
  }

  public void setParaunit(String paraunit) {
    this.paraunit = paraunit;
  }

  public String getValueType() {
    return valueType;
  }

  public void setValueType(String valueType) {
    this.valueType = valueType;
  }

  public Integer getEditflag() {
    return editflag;
  }

  public void setEditflag(Integer editflag) {
    this.editflag = editflag;
  }

  public String getDisplayflag() {
    return displayflag;
  }

  public void setDisplayflag(String displayflag) {
    this.displayflag = displayflag;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getLastsaved() {
    return lastsaved;
  }

  public void setLastsaved(String lastsaved) {
    this.lastsaved = lastsaved;
  }

  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  /**
   * 判断参数是否非法
   *
   * @return 非法 -> true; 合法 -> false
   */
  public boolean checkValueInvalid() {
    if (!StringUtil.isEmpty(this.paraval)) {
      if (SysparaUtil.VALUETYPE_AMOUNT.equals(this.valueType) && !NumberUtil.isAmount(this.paraval)) {
        return true; //参数值非金额类型
      } else if (SysparaUtil.VALUETYPE_DECIMAL.equals(this.valueType) && !NumberUtil.isDecimal(this.paraval)) {
        return true; //参数值非数值类型
      } else if (SysparaUtil.VALUETYPE_NUMBER.equals(this.valueType) && !NumberUtil.isNumber(this.paraval)) {
        return true; //参数值非整数
      } else if (SysparaUtil.VALUETYPE_SWITCH.equals(this.valueType) && !"1".equals(this.paraval) && !"0".equals(this.paraval)) {
        return true; //参数值非开关量 0/1
      } else if (SysparaUtil.VALUETYPE_DATE.equals(this.valueType) && !DateUtil.checkDatetimeValid(this.paraval, "yyyyMMdd")) {
        return true; //参数值非日期格式
      } else if (SysparaUtil.VALUETYPE_DATETIME.equals(this.valueType) && !DateUtil.checkDatetimeValid(this.paraval, "yyyyMMddHHmmss")) {
        return true; //参数值非日期时间格式
      }
    }
    return false; //默认字符串格式都合法
  }
}
