package com.supwisdom.dlpay.framework.domain;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;

public class TSysparaPK implements Serializable {
  @Id
  @Column(name = "PARAID", nullable = false, precision = 9)
  private Integer paraid;

  @Id
  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantId;

  public Integer getParaid() {
    return paraid;
  }

  public void setParaid(Integer paraid) {
    this.paraid = paraid;
  }

  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof TSysparaPK)) return false;
    TSysparaPK that = (TSysparaPK) o;
    return Objects.equals(getParaid(), that.getParaid()) &&
        Objects.equals(getTenantId(), that.getTenantId());
  }

  @Override
  public int hashCode() {
    return Objects.hash(getParaid(), getTenantId());
  }
}
