package com.supwisdom.dlpay.framework.domain;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Entity
@Table(name = "TB_TRANSCODE",
    indexes = {@Index(name = "transcode_idx", columnList = "transcode, tenantid", unique = true)})
public class TTranscode implements DictionaryTable, Serializable {
  private static final long serialVersionUID = -8077649544237207668L;
  @Id
  @Column(name = "transcode_id")
  @NotNull
  private Integer trascodeId;

  @Column(name = "TRANSCODE", nullable = false, precision = 4)
  private Integer transcode;

  @Column(name = "TRANSNAME", nullable = false, length = 100)
  private String transname;

  @Column(name = "tenantid", length = 20)
  @NotNull
  private String tenantId;

  public Integer getTranscode() {
    return transcode;
  }

  public void setTranscode(Integer transcode) {
    this.transcode = transcode;
  }

  public String getTransname() {
    return transname;
  }

  public void setTransname(String transname) {
    this.transname = transname;
  }

  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public String getDictKey() {
    return String.valueOf(this.transcode);
  }

  @Override
  public Object getDictValue() {
    return this.transname;
  }

  public Integer getTrascodeId() {
    return trascodeId;
  }

  public void setTrascodeId(Integer trascodeId) {
    this.trascodeId = trascodeId;
  }
}
