package com.supwisdom.dlpay.framework.jpa;


import com.supwisdom.dlpay.framework.jpa.page.Pagination;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.factory.annotation.Autowired;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.*;

public class BaseRepository {
    @Autowired
    protected EntityManager entityManager;

    /**
     * 查询全部（不分页） HQL 写法
     *
     * */
    protected List find(Finder finder) {
        Query query = entityManager.createQuery(finder.getOrigHql());
        finder.setParamsToQuery(query);
        return query.getResultList();
    }

    /**
     * 分页方法 HQL 写法
     * 直接查询Entity对象
     *
     * */
    protected Pagination find(Finder finder, int pageNo, int pageSize) {
        int totalCount = countQueryResult(finder);
        Pagination p = new Pagination(pageNo, pageSize, totalCount);
        if (totalCount < 1) {
            p.setList(new ArrayList());
            return p;
        }
        Query query = entityManager.createQuery(finder.getOrigHql());
        finder.setParamsToQuery(query);
        query.setFirstResult(p.getFirstResult());
        query.setMaxResults(p.getPageSize());
        List list = query.getResultList();
        p.setList(list);
        return p;
    }
    /**
     *
     * 分页方法 Native SQL 写法
     * 原生SQL
     * 使用finder.addScalar()方法，添加字段映射
     *
     * */
    protected Pagination findNative(Finder finder, ResultTransformer transformer,
                                    int pageNo, int pageSize) {
        int totalCount = countNativeQueryResult(finder);
        Pagination p = new Pagination(pageNo, pageSize, totalCount);
        if (totalCount < 1) {
            p.setList(new ArrayList());
            return p;
        }
        Query query = entityManager.createNativeQuery(finder.getOrigHql());
        finder.setParamsToQuery(query);
        NativeQuery nativeQuery = query.unwrap(NativeQuery.class);
        if(finder.columAlias!=null){
            Set<Map.Entry<String, org.hibernate.type.Type>> entrySet = finder.columAlias.entrySet();
            Iterator<Map.Entry<String, org.hibernate.type.Type>> iter = entrySet.iterator();
            while (iter.hasNext())
            {
                Map.Entry<String, org.hibernate.type.Type> entry = iter.next();
                nativeQuery.addScalar(entry.getKey(),entry.getValue());
            }
        }
        if(transformer!=null){
            nativeQuery.setResultTransformer(transformer);
        }
        query.setFirstResult(p.getFirstResult());
        query.setMaxResults(p.getPageSize());
        List list = nativeQuery.getResultList();
        p.setList(list);
        return p;
    }
    protected int countNativeQueryResult(Finder finder) {
        Query query = entityManager.createNativeQuery(finder.getRowCountHql());
        finder.setParamsToQuery(query);
        return ((Number) query.getSingleResult()).intValue();
    }

    protected int countQueryResult(Finder finder) {
        Query query = entityManager.createQuery(finder.getRowCountHql());
        finder.setParamsToQuery(query);
        return ((Number) query.getSingleResult()).intValue();
    }
    /**
     * 创建本地SQL语句的方法，不带addScalor等
     * */
    protected NativeQuery createNativeQuery(String sql){
        return entityManager.createNativeQuery(sql).unwrap(NativeQuery.class);
    }
    /**
     * 创建本地SQL语句的方法，与createNativeQuery类似，区别是不需要转换类型
     * */
    protected Query createNavQuery(String sql){
        return entityManager.createNativeQuery(sql);
    }

    /**
     * Hql 语句
     * */
    protected Query createQuery(String hql){
        return entityManager.createQuery(hql);
    }
}
