package com.supwisdom.dlpay.framework.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.supwisdom.dlpay.exception.ValidateCodeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Component("myAuthenticationFailureHandler")
public class MyAuthenticationFailureHandler extends SimpleUrlAuthenticationFailureHandler {

  @Autowired
  private ObjectMapper objectMapper;


  @Override
  public void onAuthenticationFailure(HttpServletRequest request,
                                      HttpServletResponse response, AuthenticationException exception)
      throws IOException, ServletException {

    logger.error("登录失败:" + exception.getMessage() + "|" + exception.getClass());
    String errmsg = "登录失败";
    if (exception instanceof BadCredentialsException) {
      errmsg = "账号或密码错误";
    } else if (exception instanceof LockedException) {
      errmsg = "账号被锁定";
    } else if (exception instanceof ValidateCodeException) {
      errmsg = exception.getMessage();
    }
    setDefaultFailureUrl("/login");
    super.onAuthenticationFailure(request, response, new ValidateCodeException(errmsg));
    /*response.setTransStatus(HttpStatus.OK.value());
    response.setContentType("application/json;charset=UTF-8");
    response.getWriter().write(objectMapper.writeValueAsString(JsonResult.error(400, errmsg)));*/
  }

}
