package com.supwisdom.dlpay.framework.service.impl;

import com.supwisdom.dlpay.framework.dao.OperatorDao;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.service.OperatorDetailService;
import com.supwisdom.dlpay.portal.dao.ResourceDao;
import com.supwisdom.dlpay.portal.domain.TBResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Service
public class OperatorDetailServiceImpl implements OperatorDetailService {
  @Autowired
  private OperatorDao operatorDao;
  @Autowired
  private ResourceDao resourceDao;

  @Override
  public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
    TOperator oper = operatorDao.findByOpercode(username);
    if (null == oper) {
      throw new UsernameNotFoundException("管理员不存在");
    }
    Collection<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>() {
    };

    oper.setAuthorities(authorities);
    return oper;
  }

  @Override
  public TOperator findByOperid(String operid) {
    return operatorDao.findByOperid(operid);
  }

  @Override
  public TOperator saveOper(TOperator operator) {
    return operatorDao.save(operator);
  }

  @Override
  public List<TBResource> getResByRoleId(String roleId) {
    List<TBResource> rootResource = resourceDao.findRootListByRole(roleId);
    for (TBResource resource : rootResource) {
      List<TBResource> children = resourceDao.findChildrenByRoleAndParent(roleId, resource.getResid());
      resource.setChildren(children);
    }
    return rootResource;
  }
}
