package com.supwisdom.dlpay.framework.service.impl;

import com.supwisdom.dlpay.framework.core.DatabaseConfig;
import com.supwisdom.dlpay.framework.dao.*;
import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.domain.*;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.NumberUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemUtilServiceImpl implements SystemUtilService {
  @Autowired
  private DatabaseConfig databaseConfig;
  @Autowired
  private TaskLockDao taskLockDao;
  @Autowired
  private SysparaDao sysparaDao;
  @Autowired
  private BusinessparaDao businessparaDao;

  /**
   * 获取oracle数据库时间
   */
  private SystemDateTime getOracleDatetime() {
    return taskLockDao.getOracleDatetime();
  }

  private SystemDateTime getPGDatetime() {
    return taskLockDao.getPGDatetime();
  }

  @Override
  public SystemDateTime getSysdatetime() {
    switch (databaseConfig.getPlatform()) {
      case "postgresql":
        return getPGDatetime();
      default:
        return getOracleDatetime();
    }
  }

  @Override
  public String getRefno() {
    switch (databaseConfig.getPlatform()) {
      case "postgresql":
        return taskLockDao.getPgRefno();
      default:
        return taskLockDao.getOracleRefno();
    }
  }

  @Override
  public int getSysparaValueAsInt(int paraid, int defaultValue) {
    TSyspara syspara = sysparaDao.findByParaid(paraid);
    if (null != syspara && NumberUtil.isNumber(syspara.getParaval()))
      return Integer.parseInt(syspara.getParaval());
    return defaultValue;
  }


  @Override
  public String getBusinessValue(String parakey) {
    if (!StringUtil.isEmpty(parakey)) {
      TBusinesspara businesspara = businessparaDao.findByParakey(parakey.trim());
      if (null != businesspara) return businesspara.getParaval();
    }
    return null;
  }

}
