package com.supwisdom.dlpay.framework.tenant;


import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.interceptor.KeyGenerator;

import java.lang.reflect.Method;

public class TenantCacheKeyGen implements KeyGenerator {
  private static final char delimiter = ':';

  @Override
  public Object generate(Object target, Method method, Object... params) {
    StringBuilder name = new StringBuilder();
    name.append(target.getClass().getSimpleName())
        .append(delimiter);
    String tenant = TenantContext.getTenantSchema();
    if (StringUtils.isEmpty(tenant)) {
      tenant = "default";
    }
    name.append(tenant).append(delimiter);
    for (Object item : params) {
      name.append(delimiter).append(item.toString());
    }
    return name.toString();
  }
}
