package com.supwisdom.dlpay.framework.tenant;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component("tenantHolder")
public class TenantHolder {
  private static final char delimiter = '-';

  public String getId() {
    String id = TenantContext.getTenantSchema();
    if (id == null || StringUtils.isEmpty(id)) {
      return "default";
    }
    return id;
  }

  public String genKey(String prefix, String... args) {
    StringBuilder builder = new StringBuilder();
    builder.append(getId()).append(delimiter)
        .append(prefix);
    for (String item : args) {
      builder.append(delimiter).append(item);
    }
    return builder.toString();
  }
}
