package com.supwisdom.dlpay.framework.util;

import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;

import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

/**
 * 获取随机数类
 * @author yanhua_mao
 *
 */
public class RandomUtils {
	
	/**
	 * 获取随机数
	 * @param length 位数
	 * @return 返回随机数
	 */
	public static final String randomNumber(int length) {
		char[] numbersAndLetters = null;
		Random randGen = null;
		if (length < 1) {
			return null;
		}
		if (randGen == null) {
			randGen = new Random();
			numbersAndLetters = ("0123456789").toCharArray();
		}
		char[] randBuffer = new char[length];
		for (int i = 0; i < randBuffer.length; i++) {
			randBuffer[i] = numbersAndLetters[randGen.nextInt(9)];
		}
		return new String(randBuffer);
	}
	
	/** 
     * 产生一个随机的字符串 
     *  
     * @param 字符串长度 
     * @return 
     */  
    public static String getRandomString(int length) {  
        String base = "abcdefghijklmnopqrstuvwxyz234567";  
        Random random = new Random();  
        StringBuffer sb = new StringBuffer();  
        for (int i = 0; i < length; i++) {  
            int number = random.nextInt(base.length());  
            sb.append(base.charAt(number));  
        }  
        return sb.toString();  
    }
    
    public static String getSecureRandom(){
    	SecureRandom a = new SecureRandom();
		byte[] phonesecret = new byte[10];
		a.nextBytes(phonesecret);
		
		Base32 c = new Base32();
		String s = c.encodeAsString(phonesecret);
		String savesecret = Hex.encodeHexString(phonesecret);
    	String result = s + "_"+savesecret;
		return result;
    }

	public static String getSecureRandomHex() {
		SecureRandom a = new SecureRandom();
		byte[] phonesecret = new byte[10];
		a.nextBytes(phonesecret);

		String savesecret = Hex.encodeHexString(phonesecret);
		return savesecret;
	}
	/**
	 * 
	 * @param length
	 * @return
	 */
	public static String getCharAndNumr(int length)     
	{     
	    String val = "";     
	             
	    Random random = new Random();     
	    for(int i = 0; i < length; i++)     
	    {     
	        String charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num"; // 输出字母还是数字     
	                 
	        if("char".equalsIgnoreCase(charOrNum)) // 字符串     
	        {     
	            int choice = random.nextInt(2) % 2 == 0 ? 65 : 97; //取得大写字母还是小写字母     
	            val += (char) (choice + random.nextInt(26));     
	        }     
	        else if("num".equalsIgnoreCase(charOrNum)) // 数字     
	        {     
	            val += String.valueOf(random.nextInt(10));     
	        }     
	    }     
	             
	    return val;     
	}

	public static String getUUIDStr() {
		return UUID.randomUUID().toString().replaceAll("-", "");
	}
    
}
